/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.awt.Image;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.fingerprints.interfaces.IPatternFingerprinter;
import uk.ac.ebi.reactionblast.mechanism.BondChangeCalculator;
import uk.ac.ebi.reactionblast.mechanism.MappingSolution;
import uk.ac.ebi.reactionblast.mechanism.ReactionMechanismTool;
import uk.ac.ebi.reactionblast.tools.ExtReactionManipulatorTool;
import uk.ac.ebi.reactionblast.tools.ImageGenerator;
import uk.ac.ebi.reactionblast.tools.StandardizeReaction;
import uk.ac.ebi.reactionblast.tools.TestUtility;
import uk.ac.ebi.reactionblast.tools.rxnfile.MDLV2000Reader;

public class MappingUtility
extends TestUtility {
    private static final Logger LOG = Logger.getLogger(MappingUtility.class.getName());

    public IReaction readReaction(String name) throws FileNotFoundException, CDKException, Exception {
        return this.readReaction(name, true);
    }

    public IReaction readReaction(String name, boolean reMap) throws FileNotFoundException, CDKException, Exception {
        return TestUtility.readReactionFile(name, "Output/", reMap, false);
    }

    public IReaction readReaction(String name, String dir, boolean reMap) throws FileNotFoundException, CDKException, Exception {
        return MappingUtility.readReactionFile(name, dir, reMap, false);
    }

    public IReaction readReaction(String name, String dir) throws FileNotFoundException, CDKException, Exception {
        return MappingUtility.readReactionFile(name, dir, false, false);
    }

    public IAtomContainer readMDLMolecule(String name, String dir) throws FileNotFoundException, CDKException {
        String filepath = dir + name + ".mol";
        MDLV2000Reader reader = new MDLV2000Reader(new FileReader(filepath));
        IAtomContainer AtomContainer2 = reader.read(new AtomContainer());
        AtomContainer2.setID(name);
        return AtomContainer2;
    }

    public IReaction map(IReaction reaction) {
        try {
            ReactionMechanismTool rmt = new ReactionMechanismTool(reaction, true, false, false, new StandardizeReaction());
            return rmt.getSelectedSolution().getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens();
        }
        catch (Exception e) {
            e.printStackTrace();
            return reaction;
        }
    }

    public void writeToFile(Image image, String outputDirPath, String name) throws IOException {
        File outfile;
        File outputDir = new File(outputDirPath);
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        if (!(outfile = new File(outputDir, name + ".png")).exists()) {
            outfile.createNewFile();
        }
        ImageIO.write((RenderedImage)((Object)image), "PNG", outfile);
    }

    public ReactionMechanismTool testReactions(String reactionID, String directory) throws FileNotFoundException, Exception {
        System.out.println("Mapping Reaction " + reactionID);
        IReaction cdkReaction = this.readReaction(reactionID, directory, false);
        ExtReactionManipulatorTool.addExplicitH(cdkReaction);
        ReactionMechanismTool annotation = this.getAnnotation(cdkReaction);
        MappingSolution s = annotation.getSelectedSolution();
        return annotation;
    }

    public ReactionMechanismTool getAnnotation(IReaction cdkReaction) throws AssertionError, Exception {
        ReactionMechanismTool rmt = new ReactionMechanismTool(cdkReaction, true, true, false, new StandardizeReaction());
        MappingSolution s = rmt.getSelectedSolution();
        System.out.println("Reaction ID: " + s.getReaction().getID() + ", Selected Algorithm: " + (Object)((Object)s.getAlgorithmID()));
        IReaction reactionWithCompressUnChangedHydrogens = s.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens();
        ImageGenerator.LeftToRightReactionCenterImage(reactionWithCompressUnChangedHydrogens, s.getReaction().getID() + (Object)((Object)s.getAlgorithmID()) + "RC", "Output");
        ImageGenerator.TopToBottomReactionLayoutImage(reactionWithCompressUnChangedHydrogens, s.getReaction().getID() + (Object)((Object)s.getAlgorithmID()), "Output");
        return rmt;
    }

    public BondChangeCalculator testRCReactions(String reactionID, String directory) throws FileNotFoundException, Exception {
        String NEW_LINE = System.getProperty("line.separator");
        IReaction cdkReaction = this.readReaction(reactionID, directory, false);
        ReactionMechanismTool rmt = new ReactionMechanismTool(cdkReaction, true, true, false);
        MappingSolution s = rmt.getSelectedSolution();
        new ImageGenerator().drawLeftToRightReactionLayout("Output", s.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens(), reactionID + (Object)((Object)s.getAlgorithmID()));
        StringBuilder sb = new StringBuilder();
        sb.append("++++++++++++++++++++++++++++++++++++++++++");
        sb.append(NEW_LINE);
        sb.append("Bond Changes:");
        sb.append(NEW_LINE);
        sb.append("//");
        sb.append(NEW_LINE);
        sb.append(s.getBondChangeCalculator().getFormedCleavedWFingerprint().toString());
        sb.append(NEW_LINE);
        sb.append(s.getBondChangeCalculator().getOrderChangesWFingerprint().toString());
        sb.append(NEW_LINE);
        sb.append(s.getBondChangeCalculator().getStereoChangesWFingerprint().toString());
        sb.append(NEW_LINE);
        sb.append(s.getBondChangeCalculator().getReactionCenterWFingerprint().toString());
        sb.append(NEW_LINE);
        sb.append("//");
        sb.append(NEW_LINE);
        System.out.println(sb.toString());
        StringBuilder rcSteps = new StringBuilder();
        rcSteps.append("Formed Cleaved");
        rcSteps.append(NEW_LINE);
        Map<Integer, IPatternFingerprinter> reactionCenterFormedCleavedFingerprint = s.getBondChangeCalculator().getReactionCenterFormedCleavedFingerprint();
        for (Map.Entry<Integer, IPatternFingerprinter> m : reactionCenterFormedCleavedFingerprint.entrySet()) {
            if (m.getKey() == -1) continue;
            rcSteps.append(m.getValue());
        }
        rcSteps.append("Order Change");
        rcSteps.append(NEW_LINE);
        Map<Integer, IPatternFingerprinter> reactionCenterOrderChangeFingerprint = s.getBondChangeCalculator().getReactionCenterOrderChangeFingerprint();
        for (Map.Entry entry : reactionCenterOrderChangeFingerprint.entrySet()) {
            if ((Integer)entry.getKey() == -1) continue;
            rcSteps.append(entry.getValue());
        }
        rcSteps.append("Stereo Change");
        rcSteps.append(NEW_LINE);
        Map<Integer, IPatternFingerprinter> reactionCenterStereoChangeFingerprint = s.getBondChangeCalculator().getReactionCenterStereoChangeFingerprint();
        for (Map.Entry<Integer, IPatternFingerprinter> m : reactionCenterStereoChangeFingerprint.entrySet()) {
            if (m.getKey() == -1) continue;
            rcSteps.append(m.getValue());
        }
        rcSteps.append(NEW_LINE);
        System.out.println(rcSteps.toString());
        return s.getBondChangeCalculator();
    }

    public BondChangeCalculator map(String reactionID, String directory) throws FileNotFoundException, Exception {
        IReaction cdkReaction = this.readReaction(reactionID, directory, false);
        ReactionMechanismTool rmt = new ReactionMechanismTool(cdkReaction, true, true, false);
        MappingSolution s = rmt.getSelectedSolution();
        new ImageGenerator().drawLeftToRightReactionLayout("Output", s.getBondChangeCalculator().getReactionWithCompressUnChangedHydrogens(), reactionID + (Object)((Object)s.getAlgorithmID()));
        return s.getBondChangeCalculator();
    }
}

