/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.tools;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import uk.ac.ebi.reactionblast.tools.utility.Suffix;

public class CreateDirectory {
    private static final int MKDIR_RETRY_SLEEP_MILLIS = 10;
    private static String suffix = null;
    private static final Logger LOG = Logger.getLogger(CreateDirectory.class.getName());
    private File dir;

    public static String getSuffix() {
        return suffix;
    }

    private void createDir() throws IOException {
        boolean result;
        if (this.dir == null) {
            throw new IOException("dir attribute is required");
        }
        if (this.dir.isFile()) {
            throw new IOException("Unable to create directory as a file already exists with that name: " + this.dir.getAbsolutePath());
        }
        if (!this.dir.exists() && !(result = this.mkdirs(this.dir))) {
            String msg = "Directory " + this.dir.getAbsolutePath() + " creation was not successful for an unknown reason";
            throw new IOException(msg);
        }
    }

    public void CreateDirectory() {
    }

    private boolean mkdirs(File f) {
        boolean status = true;
        if (!f.mkdirs()) {
            try {
                Thread.sleep(10L);
                status = f.mkdirs();
            }
            catch (InterruptedException ex) {
                status = f.mkdirs();
            }
        }
        return status;
    }

    private void setSuffix() throws IOException {
        Suffix init = Suffix.getInstance();
        suffix = init.getSuffix();
    }

    public File createDirectory(String dirname, boolean SUFFIX) throws IOException {
        if (SUFFIX) {
            this.setSuffix();
            String dirSuffix = CreateDirectory.getSuffix();
            this.dir = new File(dirname.concat(dirSuffix));
            this.createDir();
        } else {
            this.dir = new File(dirname);
            this.createDir();
        }
        return this.dir;
    }

    public File createDirectory(String parentDirName, String childDirName, boolean SUFFIX) throws IOException {
        if (SUFFIX) {
            this.setSuffix();
            String dirSuffix = CreateDirectory.getSuffix();
            childDirName = childDirName.concat(".");
            childDirName = childDirName.concat(dirSuffix);
            this.dir = new File(parentDirName, childDirName);
            this.createDir();
        } else {
            this.dir = new File(parentDirName, childDirName);
            this.createDir();
        }
        return this.dir;
    }
}

