/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.stereo.tools;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.openscience.cdk.geometry.cip.CIPTool;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;
import uk.ac.ebi.reactionblast.stereo.compare.ChiralityTool;
import uk.ac.ebi.reactionblast.stereo.wedge.WedgeStereoLifter;

public class Chirality2DTool
implements ChiralityTool {
    private static final Logger LOG = Logger.getLogger(Chirality2DTool.class.getName());

    public static IStereoAndConformation getChirality2D(WedgeStereoLifter lifter, IAtom atom, IAtomContainer atomContainer) {
        IStereoElement stereoElement = lifter.lift(atom, atomContainer);
        return Chirality2DTool.getChirality2D(stereoElement, atomContainer);
    }

    public static IStereoAndConformation getChirality2D(IStereoElement stereoElement, IAtomContainer atomContainer) {
        if (stereoElement instanceof ITetrahedralChirality) {
            CIPTool.CIP_CHIRALITY chiral = CIPTool.getCIPChirality(atomContainer, (ITetrahedralChirality)stereoElement);
            switch (chiral) {
                case NONE: {
                    return IStereoAndConformation.NONE;
                }
                case R: {
                    return IStereoAndConformation.R;
                }
                case S: {
                    return IStereoAndConformation.S;
                }
            }
            return IStereoAndConformation.NONE;
        }
        return IStereoAndConformation.NONE;
    }

    @Override
    public Map<IAtom, IStereoAndConformation> getTetrahedralChiralities(IAtomContainer atomContainer) {
        return this.getTetrahedralChiralities(atomContainer, false);
    }

    @Override
    public Map<IAtom, IStereoAndConformation> getTetrahedralChiralities(IAtomContainer atomContainer, boolean getNoneAssesments) {
        HashMap<IAtom, IStereoAndConformation> chiralities = new HashMap<IAtom, IStereoAndConformation>();
        WedgeStereoLifter lifter = new WedgeStereoLifter();
        for (IAtom atom : atomContainer.atoms()) {
            IStereoAndConformation chirality = Chirality2DTool.getChirality2D(lifter, atom, atomContainer);
            if (!getNoneAssesments && chirality == IStereoAndConformation.NONE) continue;
            chiralities.put(atom, chirality);
        }
        return chiralities;
    }
}

