/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.signature;

import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import signature.AbstractVertexSignature;
import signature.ColoredTree;
import uk.ac.ebi.reactionblast.signature.BaseMoleculeSignature;
import uk.ac.ebi.reactionblast.signature.RBlastAtomSignature;
import uk.ac.ebi.reactionblast.signature.RBlastMoleculeFromSignatureBuilder;
import uk.ac.ebi.reactionblast.signature.RBlastMoleculeSignatureLabellingAdaptor;
import uk.ac.ebi.reactionblast.signature.RBlastSmilesGenerator;
import uk.ac.ebi.reactionblast.tools.labelling.AtomContainerAtomPermutor;
import uk.ac.ebi.reactionblast.tools.labelling.ICanonicalMoleculeLabeller;

public class RBlastMoleculeSignature
extends BaseMoleculeSignature {
    private static final Logger LOG = Logger.getLogger(RBlastMoleculeSignature.class.getName());
    private boolean useAromatics = true;
    private boolean useCharge = true;
    private boolean isBondSensitive = true;
    private RBlastMoleculeFromSignatureBuilder builder;

    public RBlastMoleculeSignature(IAtomContainer atomContainer) {
        super(atomContainer);
        this.builder = new RBlastMoleculeFromSignatureBuilder(atomContainer.getBuilder());
    }

    public int getAtomCount() {
        return this.getVertexCount();
    }

    public boolean isUseAromatics() {
        return this.useAromatics;
    }

    public void setUseAromatics(boolean useAromatics) {
        this.useAromatics = useAromatics;
    }

    public boolean isUseCharge() {
        return this.useCharge;
    }

    public void setUseCharge(boolean useCharge) {
        this.useCharge = useCharge;
    }

    public boolean isBondSensitive() {
        return this.isBondSensitive;
    }

    public void setBondSensitive(boolean isBondSensitive) {
        this.isBondSensitive = isBondSensitive;
    }

    public String getMoleculeCanonicalSignatureString() {
        return super.toCanonicalString();
    }

    public String getSignatureStringForAtom(int atomIndex) {
        return this.getAtomSignature(atomIndex).toCanonicalString();
    }

    public String getSignatureStringForAtom(int atomIndex, int height) {
        return this.getAtomSignature(atomIndex, height).toCanonicalString();
    }

    public RBlastAtomSignature getAtomSignature(int atomIndex) {
        RBlastAtomSignature atomSignature = (RBlastAtomSignature)this.signatureForVertex(atomIndex);
        this.setFlags(atomSignature);
        return atomSignature;
    }

    public RBlastAtomSignature getAtomSignature(int atomIndex, int height) {
        RBlastAtomSignature atomSignature = new RBlastAtomSignature(atomIndex, this.atomContainer, height);
        this.setFlags(atomSignature);
        return atomSignature;
    }

    private void setFlags(RBlastAtomSignature atomSignature) {
        atomSignature.setUseAromatics(this.useAromatics);
        atomSignature.setUseCharge(this.useCharge);
        atomSignature.setBondSensitive(this.isBondSensitive);
    }

    private void setFlags(RBlastMoleculeFromSignatureBuilder builder) {
        builder.setUseAromatics(this.useAromatics);
        builder.setUseCharge(this.useCharge);
        builder.setBondSensitive(this.isBondSensitive);
    }

    public String getSmilesForAtomSignature(int atomIndex, int height) {
        return this.getSmilesForAtomSignature(atomIndex, height, new RBlastMoleculeSignatureLabellingAdaptor());
    }

    public String getSmilesForAtomSignature(int atomIndex, int height, ICanonicalMoleculeLabeller labeller) {
        String atomSignatureString = this.getSignatureStringForAtom(atomIndex, height);
        ColoredTree tree = AbstractVertexSignature.parse(atomSignatureString);
        this.builder = new RBlastMoleculeFromSignatureBuilder(this.atomContainer.getBuilder());
        this.setFlags(this.builder);
        this.builder.makeFromColoredTree(tree);
        IAtomContainer fragment = this.builder.getAtomContainer();
        fragment = AtomContainerAtomPermutor.permute(labeller.getCanonicalPermutation(fragment), fragment);
        RBlastSmilesGenerator smilesGenerator = new RBlastSmilesGenerator(false, labeller);
        try {
            return smilesGenerator.createSMILESWithoutCheckForMultipleMolecules(fragment, false, new boolean[fragment.getBondCount()]);
        }
        catch (CDKException e) {
            e.printStackTrace();
            return "";
        }
    }

    public IAtomContainer getFragment(int atomIndex, int height) {
        String atomSignatureString = this.getSignatureStringForAtom(atomIndex, height);
        return this.makeMoleculeFromSignature(atomSignatureString);
    }

    public IAtomContainer makeMoleculeFromSignature(String signatureString) {
        ColoredTree tree = AbstractVertexSignature.parse(signatureString);
        this.builder = new RBlastMoleculeFromSignatureBuilder(this.atomContainer.getBuilder());
        this.setFlags(this.builder);
        this.builder.makeFromColoredTree(tree);
        return this.builder.getAtomContainer();
    }
}

