/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism.helper;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import uk.ac.ebi.reactionblast.mechanism.BEMatrix;
import uk.ac.ebi.reactionblast.mechanism.RMatrix;

public class MatrixPrinter {
    private static final Logger LOG = Logger.getLogger(MatrixPrinter.class.getName());

    public static void printReactionMatrix(RMatrix rMatrix) {
        try {
            int i;
            for (i = 0; i < rMatrix.getRowDimension(); ++i) {
                System.out.print("\t\t" + i);
            }
            System.out.println();
            for (i = 0; i < rMatrix.getRowDimension() - 1; ++i) {
                System.out.print("\t\t" + rMatrix.getReactantBEMatrix().getAtom(i).getSymbol() + rMatrix.getReactantBEMatrix().getAtom(i).getID());
            }
            System.out.println();
            for (i = 0; i < rMatrix.getRowDimension() - 1; ++i) {
                System.out.print("\t\t" + rMatrix.getProductBEMatrix().getAtom(i).getSymbol() + rMatrix.getProductBEMatrix().getAtom(i).getID());
            }
            System.out.println();
            for (i = 0; i < rMatrix.getRowDimension(); ++i) {
                if (i == rMatrix.getRowDimension() - 1) {
                    System.out.print("\t");
                } else {
                    System.out.print(rMatrix.getReactantBEMatrix().getAtom(i).getSymbol() + rMatrix.getReactantBEMatrix().getAtom(i).getID() + "\t" + rMatrix.getProductBEMatrix().getAtom(i).getSymbol() + rMatrix.getProductBEMatrix().getAtom(i).getID());
                }
                for (int j = 0; j < rMatrix.getColumnDimension(); ++j) {
                    System.out.print("\t" + rMatrix.getValue(i, j));
                }
                System.out.println();
            }
        }
        catch (CDKException ex) {
            System.err.println("A CDKException has been arisen while printing the RMatrix");
        }
    }

    public static void writeReactionMatrix(File outputFile, RMatrix rMatrix) throws IOException {
        FileWriter matrixFile = new FileWriter(outputFile);
        try (BufferedWriter matrixFileWriter = new BufferedWriter(matrixFile);){
            matrixFileWriter.newLine();
            try {
                int i;
                for (i = 0; i < rMatrix.getRowDimension(); ++i) {
                    matrixFileWriter.write("\t" + i);
                }
                matrixFileWriter.newLine();
                for (i = 0; i < rMatrix.getRowDimension() - 1; ++i) {
                    matrixFileWriter.write("\t" + rMatrix.getReactantBEMatrix().getAtom(i).getSymbol() + rMatrix.getReactantBEMatrix().getAtom(i).getID());
                }
                matrixFileWriter.newLine();
                for (i = 0; i < rMatrix.getRowDimension() - 1; ++i) {
                    matrixFileWriter.write("\t" + rMatrix.getProductBEMatrix().getAtom(i).getSymbol() + rMatrix.getProductBEMatrix().getAtom(i).getID());
                }
                matrixFileWriter.newLine();
                for (i = 0; i < rMatrix.getRowDimension(); ++i) {
                    if (i == rMatrix.getRowDimension() - 1) {
                        matrixFileWriter.write("\t");
                    } else {
                        matrixFileWriter.write(rMatrix.getReactantBEMatrix().getAtom(i).getSymbol() + rMatrix.getReactantBEMatrix().getAtom(i).getID() + "\t" + rMatrix.getProductBEMatrix().getAtom(i).getSymbol() + rMatrix.getProductBEMatrix().getAtom(i).getID());
                    }
                    for (int j = 0; j < rMatrix.getColumnDimension(); ++j) {
                        matrixFileWriter.write("\t" + rMatrix.getValue(i, j));
                    }
                    matrixFileWriter.newLine();
                }
                matrixFileWriter.close();
            }
            catch (CDKException ex) {
                System.err.println("A CDKException has been arisen while printing the RMatrix");
            }
        }
    }

    public static void printBEMatrix(BEMatrix beMatrix) {
        int i;
        List<IAtom> atomArray = beMatrix.getAtoms();
        System.out.println(atomArray.size());
        for (i = 0; i < atomArray.size(); ++i) {
            System.out.print(atomArray.get(i).getSymbol() + atomArray.get(i).getID() + "\t");
        }
        System.out.println();
        for (i = 0; i < beMatrix.getRowDimension(); ++i) {
            for (int j = 0; j < beMatrix.getColumnDimension(); ++j) {
                System.out.print(beMatrix.getValue(i, j) + "\t");
            }
            System.out.println();
        }
    }

    public static void writeBEMatrix(File outputFile, BEMatrix beMatrix) throws IOException {
        List<IAtom> atomArray = beMatrix.getAtoms();
        FileWriter matrixFile = new FileWriter(outputFile);
        try (BufferedWriter matrixFileWriter = new BufferedWriter(matrixFile);){
            int i;
            matrixFileWriter.newLine();
            matrixFileWriter.write(atomArray.size());
            matrixFileWriter.newLine();
            for (i = 0; i < atomArray.size(); ++i) {
                matrixFileWriter.write(atomArray.get(i).getSymbol() + atomArray.get(i).getID() + "\t");
            }
            matrixFileWriter.newLine();
            for (i = 0; i < beMatrix.getRowDimension(); ++i) {
                for (int j = 0; j < beMatrix.getColumnDimension(); ++j) {
                    matrixFileWriter.write(beMatrix.getValue(i, j) + "\t");
                }
                matrixFileWriter.newLine();
            }
            matrixFileWriter.close();
        }
    }

    MatrixPrinter() {
    }
}

