/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.mechanism.StereoChange;
import uk.ac.ebi.reactionblast.stereo.IStereoAndConformation;

public class StereogenicCenterCalculator
implements Serializable {
    private static final long serialVersionUID = -1420740601548197863L;
    private static final Logger LOG = Logger.getLogger(StereogenicCenterCalculator.class.getName());

    public synchronized List<StereoChange> compare(IReaction reaction, Map<IAtom, IStereoAndConformation> chirality2DCDK, Map<IAtom, IStereoAndConformation> chirality2DChemaxon, Map<IAtom, IStereoAndConformation> chirality3DChemaxon) {
        ArrayList<StereoChange> stereoChangeList = new ArrayList<StereoChange>();
        ArrayList<IAtom> queryAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                queryAtoms.add(a);
            }
        }
        ArrayList<IAtom> targetAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                targetAtoms.add(a);
            }
        }
        for (IAtom atomQ : queryAtoms) {
            for (IAtom atomT : targetAtoms) {
                StereoChange sc;
                if (!atomQ.getID().equals(atomT.getID()) || atomQ.getSymbol().equalsIgnoreCase("H")) continue;
                IStereoAndConformation rAtom2DCDKStereo = chirality2DCDK.get(atomQ);
                IStereoAndConformation pAtom2DCDKStereo = chirality2DCDK.get(atomT);
                IStereoAndConformation rAtom2DStereo = chirality2DChemaxon.get(atomQ);
                IStereoAndConformation pAtom2DStereo = chirality2DChemaxon.get(atomT);
                IStereoAndConformation rAtom3DStereo = chirality3DChemaxon.get(atomQ);
                IStereoAndConformation pAtom3DStereo = chirality3DChemaxon.get(atomT);
                if (this.isStereogenicChange(rAtom2DCDKStereo, pAtom2DCDKStereo)) {
                    sc = new StereoChange(rAtom2DCDKStereo, pAtom2DCDKStereo, atomQ, atomT);
                    stereoChangeList.add(sc);
                }
                if (!this.isStereogenicChange(rAtom3DStereo, pAtom3DStereo)) continue;
                sc = new StereoChange(rAtom3DStereo, pAtom3DStereo, atomQ, atomT);
                stereoChangeList.add(sc);
            }
        }
        return stereoChangeList;
    }

    public synchronized List<StereoChange> compare(IReaction reaction, Map<IAtom, IStereoAndConformation> chirality2DCDK, Map<IAtom, IStereoAndConformation> chirality2DChemaxon) {
        ArrayList<StereoChange> stereoChangeList = new ArrayList<StereoChange>();
        ArrayList<IAtom> queryAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                queryAtoms.add(a);
            }
        }
        ArrayList<IAtom> targetAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                targetAtoms.add(a);
            }
        }
        for (IAtom atomQ : queryAtoms) {
            for (IAtom atomT : targetAtoms) {
                StereoChange sc;
                IStereoAndConformation pAtom2DStereo;
                if (!atomQ.getID().equals(atomT.getID()) || atomQ.getSymbol().equalsIgnoreCase("H")) continue;
                IStereoAndConformation rAtom2DCDKStereo = chirality2DCDK.get(atomQ);
                IStereoAndConformation pAtom2DCDKStereo = chirality2DCDK.get(atomT);
                IStereoAndConformation rAtom2DStereo = chirality2DChemaxon.get(atomQ);
                if (this.isStereogenicChange(rAtom2DStereo, pAtom2DStereo = chirality2DChemaxon.get(atomT))) {
                    sc = new StereoChange(rAtom2DStereo, pAtom2DStereo, atomQ, atomT);
                    stereoChangeList.add(sc);
                }
                if (!this.isStereogenicChange(rAtom2DCDKStereo, pAtom2DCDKStereo)) continue;
                sc = new StereoChange(rAtom2DCDKStereo, pAtom2DCDKStereo, atomQ, atomT);
                stereoChangeList.add(sc);
            }
        }
        return stereoChangeList;
    }

    public synchronized List<StereoChange> compare(IReaction reaction, Map<IAtom, IStereoAndConformation> chirality2DCDK) {
        ArrayList<StereoChange> stereoChangeList = new ArrayList<StereoChange>();
        ArrayList<IAtom> queryAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getReactants().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                queryAtoms.add(a);
            }
        }
        ArrayList<IAtom> targetAtoms = new ArrayList<IAtom>();
        for (IAtomContainer ac : reaction.getProducts().atomContainers()) {
            for (IAtom a : ac.atoms()) {
                targetAtoms.add(a);
            }
        }
        for (IAtom atomQ : queryAtoms) {
            for (IAtom atomT : targetAtoms) {
                IStereoAndConformation pAtom2DCDKStereo;
                IStereoAndConformation rAtom2DCDKStereo;
                if (!atomQ.getID().equals(atomT.getID()) || atomQ.getSymbol().equalsIgnoreCase("H") || !this.isStereogenicChange(rAtom2DCDKStereo = chirality2DCDK.get(atomQ), pAtom2DCDKStereo = chirality2DCDK.get(atomT))) continue;
                StereoChange sc = new StereoChange(rAtom2DCDKStereo, pAtom2DCDKStereo, atomQ, atomT);
                stereoChangeList.add(sc);
            }
        }
        return stereoChangeList;
    }

    public synchronized boolean isStereogenicChange(IStereoAndConformation a, IStereoAndConformation b) {
        if (a.equals(IStereoAndConformation.S) && b.equals(IStereoAndConformation.NONE)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.R) && b.equals(IStereoAndConformation.NONE)) {
            return true;
        }
        if (b.equals(IStereoAndConformation.S) && a.equals(IStereoAndConformation.NONE)) {
            return true;
        }
        if (b.equals(IStereoAndConformation.R) && a.equals(IStereoAndConformation.NONE)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.R) && b.equals(IStereoAndConformation.S)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.S) && b.equals(IStereoAndConformation.R)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.S) && b.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.R) && b.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (b.equals(IStereoAndConformation.S) && a.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (b.equals(IStereoAndConformation.R) && a.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.EITHER) && b.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.NONE) && b.equals(IStereoAndConformation.EITHER)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.EITHER) && b.equals(IStereoAndConformation.NONE)) {
            return true;
        }
        if (a.equals(IStereoAndConformation.Z) && b.equals(IStereoAndConformation.E)) {
            return true;
        }
        return a.equals(IStereoAndConformation.E) && b.equals(IStereoAndConformation.Z);
    }
}

