/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mechanism;

import java.io.Serializable;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.mapping.Reactor;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;
import uk.ac.ebi.reactionblast.mechanism.BondChangeCalculator;

public class MappingSolution
implements Serializable {
    private static final long serialVersionUID = 1678787866L;
    private static final Logger LOG = Logger.getLogger(MappingSolution.class.getName());
    private final IMappingAlgorithm algorithmID;
    private final double bondEnergySum;
    private final double energyDelta;
    private final int totalBondChanges;
    private final int totalFragmentChanges;
    private final int totalStereoChanges;
    private final int smallestFragmentCount;
    private final int totalCarbonBondChanges;
    private final IReaction reaction;
    private final Reactor reactor;
    private final int totalChanges;
    private boolean chosen;
    private final BondChangeCalculator bondChangeCalculator;
    private boolean generate3D;
    private boolean generate2D;

    public MappingSolution(BondChangeCalculator bondChangeCalculator, IMappingAlgorithm ma, IReaction reaction, Reactor reactor, double bondEnergyChange, int totalCarbonBondChanges, int totalBondChanges, int totalFragmentChanges, int totalStereoChanges, int smallestFragmentCount, int localScore, double energyDelta) {
        this.algorithmID = ma;
        this.bondEnergySum = bondEnergyChange;
        this.totalBondChanges = totalBondChanges;
        this.totalFragmentChanges = totalFragmentChanges;
        this.totalStereoChanges = totalStereoChanges;
        this.smallestFragmentCount = smallestFragmentCount;
        this.reaction = reaction;
        this.reactor = reactor;
        this.totalChanges = localScore;
        this.bondChangeCalculator = bondChangeCalculator;
        this.totalCarbonBondChanges = totalCarbonBondChanges;
        this.chosen = false;
        this.generate2D = false;
        this.generate3D = false;
        this.energyDelta = energyDelta;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        String property = System.getProperty("line.separator");
        sb.append(property);
        sb.append("-----------------------------------");
        sb.append(property);
        sb.append("Chosen Algorithm is= ").append(this.getAlgorithmID().description());
        sb.append(", ");
        sb.append(property).append("Scores=(Chaos Delta:");
        sb.append(this.getTotalFragmentChanges()).append(", Sigma:");
        sb.append(this.getTotalBondChanges()).append(", Energy:");
        sb.append(this.getBondEnergySum()).append(")");
        sb.append(property);
        sb.append("-----------------------------------");
        sb.append(property);
        sb.append("MappingSolution{algorithmID=").append((Object)this.algorithmID).append(", bondEnergyChange=").append(this.bondEnergySum).append(", totalBondChanges=").append(this.totalBondChanges).append(", totalFragmentChanges=").append(this.totalFragmentChanges).append(", totalStereoChanges=").append(this.totalStereoChanges).append(", smallestFragmentCount=").append(this.smallestFragmentCount).append(", totalChanges=").append(this.totalChanges).append(", chosen=").append(this.chosen).append(", generate3D=").append(this.generate3D).append(", generate2D=").append(this.generate2D).append('}');
        sb.append(property);
        return sb.toString();
    }

    public IMappingAlgorithm getAlgorithmID() {
        return this.algorithmID;
    }

    public double getBondEnergySum() {
        return this.bondEnergySum;
    }

    public int getTotalBondChanges() {
        return this.totalBondChanges;
    }

    public int getTotalFragmentChanges() {
        return this.totalFragmentChanges;
    }

    public int getTotalStereoChanges() {
        return this.totalStereoChanges;
    }

    public int getSmallestFragmentCount() {
        return this.smallestFragmentCount;
    }

    public IReaction getReaction() {
        return this.reaction;
    }

    public Reactor getReactor() {
        return this.reactor;
    }

    public int getTotalChanges() {
        return this.totalChanges;
    }

    public boolean isChosen() {
        return this.chosen;
    }

    public BondChangeCalculator getBondChangeCalculator() {
        return this.bondChangeCalculator;
    }

    void setChosen(boolean chosen) {
        this.chosen = chosen;
    }

    boolean isGenerate3D() {
        return this.generate3D;
    }

    void setGenerate3D(boolean generate3D) {
        this.generate3D = generate3D;
    }

    boolean isGenerate2D() {
        return this.generate2D;
    }

    void setGenerate2D(boolean generate2D) {
        this.generate2D = generate2D;
    }

    public int getTotalCarbonBondChanges() {
        return this.totalCarbonBondChanges;
    }

    public double getEnergyDelta() {
        return this.energyDelta;
    }
}

