/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.container;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.Fingerprinter;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.interfaces.IReactionSet;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.smsd.Substructure;
import uk.ac.ebi.reactionblast.containers.MolContainer;
import uk.ac.ebi.reactionblast.fingerprints.FingerprintGenerator;
import uk.ac.ebi.reactionblast.fingerprints.tools.Similarity;
import uk.ac.ebi.reactionblast.tools.AtomContainerSetComparator;
import uk.ac.ebi.reactionblast.tools.BasicDebugger;
import uk.ac.ebi.reactionblast.tools.ExtAtomContainerManipulator;

public class CDKReactionBuilder
extends BasicDebugger
implements Serializable {
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = 19869866609698L;
    private static final Logger LOG = Logger.getLogger(CDKReactionBuilder.class.getName());
    private final IReactionSet reactionSet = DefaultChemObjectBuilder.getInstance().newInstance(IReactionSet.class, new Object[0]);
    private int moleculeCounter = 0;
    private final Map<String, Double> stoichiometryMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, BitSet> fingerprintMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, IAtomContainer> moleculeMap = Collections.synchronizedMap(new HashMap());

    public String toString() {
        return "CDKReactionBuilder{reactionSet=" + this.reactionSet + ", moleculeCounter=" + this.moleculeCounter + ", stoichiometryMap=" + this.stoichiometryMap + ", fingerprintMap=" + this.fingerprintMap + ", moleculeMap=" + this.moleculeMap + '}';
    }

    public synchronized void standardize(IReactionSet reactionSet) throws Exception {
        for (IReaction reaction : reactionSet.reactions()) {
            IReaction standardizedReaction = this.standardize(reaction);
            reactionSet.addReaction(standardizedReaction);
        }
    }

    public synchronized IReaction standardize(IReaction reaction) throws Exception {
        AtomContainerSetComparator comparator;
        Object molWithH;
        IAtomContainer gMol;
        Double tempStoic;
        String id;
        int old_atom_rank_index_reactant = 1;
        int old_atom_rank_index_product = 1;
        ArrayList<IAtomContainer> _metabolites = new ArrayList<IAtomContainer>();
        IReaction standardizedReaction = DefaultChemObjectBuilder.getInstance().newInstance(IReaction.class, new Object[0]);
        String reactionID = reaction.getID();
        int reactionCounter = 1;
        if (reactionID == null) {
            reactionID = "R" + Long.toString(reactionCounter++);
            reaction.setID(reactionID);
        }
        _metabolites.clear();
        standardizedReaction.setID(reactionID);
        this.stoichiometryMap.clear();
        for (IAtomContainer mol : reaction.getReactants().atomContainers()) {
            id = mol.getID() == null || mol.getID().isEmpty() ? null : mol.getID();
            tempStoic = 1.0;
            if (reaction.getReactantCoefficient(mol) > 0.0) {
                tempStoic = reaction.getReactantCoefficient(mol);
            }
            gMol = ExtAtomContainerManipulator.cloneWithIDs(mol);
            for (IAtom a : gMol.atoms()) {
                if (a.getProperties() == null) {
                    a.addProperties(new HashMap<Object, Object>());
                }
                a.setProperty("OLD_RANK", old_atom_rank_index_reactant++);
            }
            ExtAtomContainerManipulator.fixDativeBonds(gMol);
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(gMol);
            molWithH = gMol;
            ExtAtomContainerManipulator.aromatizeMolecule((IAtomContainer)molWithH);
            if (id == null) {
                molWithH = this.setProperty((IAtomContainer)molWithH);
            } else {
                molWithH.setID(id);
            }
            if (this.stoichiometryMap.containsKey(molWithH.getID())) {
                tempStoic = tempStoic + this.stoichiometryMap.get(molWithH.getID());
                this.stoichiometryMap.put(molWithH.getID(), tempStoic);
                continue;
            }
            this.stoichiometryMap.put(molWithH.getID(), tempStoic);
            _metabolites.add((IAtomContainer)molWithH);
        }
        try {
            comparator = new AtomContainerSetComparator();
            Collections.sort(_metabolites, comparator);
        }
        catch (Exception ex) {
            Logger.getLogger(CDKReactionBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setReactantMolecule(standardizedReaction, _metabolites);
        _metabolites.clear();
        for (IAtomContainer mol : reaction.getProducts().atomContainers()) {
            id = mol.getID() == null || mol.getID().isEmpty() ? null : mol.getID();
            tempStoic = 1.0;
            if (reaction.getProductCoefficient(mol) > 0.0) {
                tempStoic = reaction.getProductCoefficient(mol);
            }
            gMol = ExtAtomContainerManipulator.cloneWithIDs(mol);
            for (IAtom a : gMol.atoms()) {
                if (a.getProperties() == null) {
                    a.addProperties(new HashMap<Object, Object>());
                }
                a.setProperty("OLD_RANK", old_atom_rank_index_product++);
            }
            ExtAtomContainerManipulator.fixDativeBonds(gMol);
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(gMol);
            molWithH = gMol;
            ExtAtomContainerManipulator.aromatizeMolecule((IAtomContainer)molWithH);
            if (id == null) {
                molWithH = this.setProperty((IAtomContainer)molWithH);
            } else {
                molWithH.setID(id);
            }
            if (this.stoichiometryMap.containsKey(molWithH.getID())) {
                tempStoic = tempStoic + this.stoichiometryMap.get(molWithH.getID());
                this.stoichiometryMap.put(molWithH.getID(), tempStoic);
                continue;
            }
            this.stoichiometryMap.put(molWithH.getID(), tempStoic);
            _metabolites.add((IAtomContainer)molWithH);
        }
        try {
            comparator = new AtomContainerSetComparator();
            Collections.sort(_metabolites, comparator);
        }
        catch (Exception ex) {
            Logger.getLogger(CDKReactionBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        this.setProductMolecule(standardizedReaction, _metabolites);
        _metabolites.clear();
        this.reactionSet.addReaction(standardizedReaction);
        if (reaction.getDirection() != null) {
            standardizedReaction.setDirection(reaction.getDirection());
        } else {
            standardizedReaction.setDirection(IReaction.Direction.BIDIRECTIONAL);
        }
        this.fingerprintMap.clear();
        this.moleculeMap.clear();
        this.stoichiometryMap.clear();
        return standardizedReaction;
    }

    private IAtomContainer setProperty(IAtomContainer molecule) throws Exception {
        String molID = molecule.getID() == null || molecule.getID().isEmpty() ? null : molecule.getID();
        try {
            try {
                if (molecule.getAtomCount() > 0) {
                    FingerprintGenerator fpr = new FingerprintGenerator();
                    BitSet fingerprint_Present_Mol = fpr.getFingerprint(molecule);
                    if (fingerprint_Present_Mol.isEmpty()) {
                        Fingerprinter fingerprinter = new Fingerprinter();
                        fingerprint_Present_Mol = fingerprinter.getBitFingerprint(molecule).asBitSet();
                    }
                    if (!fingerprint_Present_Mol.isEmpty()) {
                        if (!this.isValuePresent(fingerprint_Present_Mol)) {
                            if (molID == null) {
                                ++this.moleculeCounter;
                                int val = this.moleculeCounter + 100000;
                                String Temp = Integer.toString(val);
                                molID = Temp.replaceFirst("1", "M");
                                molecule.setID(molID);
                            }
                            this.fingerprintMap.put(molID, fingerprint_Present_Mol);
                            this.moleculeMap.put(molID, molecule);
                        } else if (this.isValuePresent(fingerprint_Present_Mol) && this.isAtomContainerPresent(this.getMoleculeID(fingerprint_Present_Mol), molecule)) {
                            if (molID == null) {
                                molID = this.getMoleculeID(fingerprint_Present_Mol);
                                molecule.setID(molID);
                            }
                        } else {
                            if (molID == null) {
                                ++this.moleculeCounter;
                                int val = this.moleculeCounter + 100000;
                                String Temp = Integer.toString(val);
                                molID = Temp.replaceFirst("1", "M");
                                molecule.setID(molID);
                            }
                            this.fingerprintMap.put(molID, fingerprint_Present_Mol);
                            this.moleculeMap.put(molID, molecule);
                        }
                    } else {
                        System.err.println("error: Fingerprint can't be generated for this molecule " + SmilesGenerator.generic().create(molecule));
                    }
                } else {
                    System.err.println("error: Mol file should contain atleast one atom! " + SmilesGenerator.generic().create(molecule));
                }
            }
            catch (CDKException ex) {
                Logger.getLogger(CDKReactionBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (Exception ex) {
                Logger.getLogger(CDKReactionBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (molecule.getID() == null) {
                try {
                    throw new CDKException("Mol ID is NULL");
                }
                catch (CDKException ex) {
                    Logger.getLogger(CDKReactionBuilder.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        catch (Exception ex) {
            Logger.getLogger(CDKReactionBuilder.class.getName()).log(Level.SEVERE, null, ex);
        }
        return molecule;
    }

    private void setReactantMolecule(IReaction IR, Collection<IAtomContainer> metabolites) {
        for (IAtomContainer mol : metabolites) {
            mol.setProperty("STOICHIOMETRY", this.stoichiometryMap.get(mol.getID()));
            IR.addReactant(mol, this.stoichiometryMap.get(mol.getID()));
        }
        metabolites.clear();
        this.stoichiometryMap.clear();
    }

    private void setProductMolecule(IReaction IR, Collection<IAtomContainer> metabolites) {
        for (IAtomContainer mol : metabolites) {
            mol.setProperty("STOICHIOMETRY", this.stoichiometryMap.get(mol.getID()));
            IR.addProduct(mol, this.stoichiometryMap.get(mol.getID()));
        }
        metabolites.clear();
        this.stoichiometryMap.clear();
    }

    private boolean isValuePresent(BitSet value) throws IOException {
        for (BitSet bitset : this.fingerprintMap.values()) {
            try {
                if ((double)Similarity.getTanimotoSimilarity(value, bitset) != 1.0) continue;
                return true;
            }
            catch (Exception ex) {
                Logger.getLogger(CDKReactionBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return false;
    }

    private String getMoleculeID(BitSet bitset) throws IOException {
        String Key2 = null;
        for (Map.Entry<String, BitSet> map : this.fingerprintMap.entrySet()) {
            String key = map.getKey();
            try {
                if ((double)Similarity.getTanimotoSimilarity(map.getValue(), bitset) != 1.0) continue;
                Key2 = key;
                break;
            }
            catch (Exception ex) {
                Logger.getLogger(CDKReactionBuilder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return Key2;
    }

    private boolean isAtomContainerPresent(String key, IAtomContainer molecule) throws Exception {
        try {
            boolean flag = this.moleculeMap.containsKey(key);
            if (flag && molecule.getAtomCount() > 0) {
                IAtomContainer molFromContainer = this.moleculeMap.get(key);
                return this.isIdentical(molecule, molFromContainer, true);
            }
        }
        catch (Exception ex) {
            Logger.getLogger(MolContainer.class.getName()).log(Level.SEVERE, null, ex);
        }
        return false;
    }

    private boolean isIdentical(IAtomContainer queryMol_org, IAtomContainer targetMol_org, boolean removeHydrogen) throws Exception {
        IAtomContainer queryMol = queryMol_org.clone();
        IAtomContainer targetMol = targetMol_org.clone();
        if (removeHydrogen) {
            queryMol = ExtAtomContainerManipulator.removeHydrogens(queryMol);
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(queryMol);
            ExtAtomContainerManipulator.aromatizeMolecule(queryMol);
            targetMol = ExtAtomContainerManipulator.removeHydrogens(targetMol);
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(targetMol);
            ExtAtomContainerManipulator.aromatizeMolecule(targetMol);
        }
        if (queryMol.getAtomCount() == 1 && targetMol.getAtomCount() == 1) {
            IAtom a = queryMol.atoms().iterator().next();
            IAtom b = targetMol.atoms().iterator().next();
            return a.getSymbol().equalsIgnoreCase(b.getSymbol()) && Objects.equals(a.getFormalCharge(), b.getFormalCharge()) && queryMol.getElectronContainerCount() == targetMol.getElectronContainerCount();
        }
        TreeMap<String, Integer> atomUniqueCounter1 = new TreeMap<String, Integer>();
        TreeMap<String, Integer> atomUniqueCounter2 = new TreeMap<String, Integer>();
        int leftHandAtomCount = 0;
        for (IAtom a : queryMol.atoms()) {
            if (a.getSymbol().equals("H")) continue;
            if (!atomUniqueCounter1.containsKey(a.getSymbol())) {
                atomUniqueCounter1.put(a.getSymbol(), 1);
            } else {
                int counter = (Integer)atomUniqueCounter1.get(a.getSymbol()) + 1;
                atomUniqueCounter1.put(a.getSymbol(), counter);
            }
            ++leftHandAtomCount;
        }
        int rightHandAtomCount = 0;
        for (IAtom b : targetMol.atoms()) {
            if (b.getSymbol().equals("H")) continue;
            if (!atomUniqueCounter2.containsKey(b.getSymbol())) {
                atomUniqueCounter2.put(b.getSymbol(), 1);
            } else {
                int counter = (Integer)atomUniqueCounter2.get(b.getSymbol()) + 1;
                atomUniqueCounter2.put(b.getSymbol(), counter);
            }
            ++rightHandAtomCount;
        }
        if (leftHandAtomCount != rightHandAtomCount) {
            return false;
        }
        if (!atomUniqueCounter1.keySet().equals(atomUniqueCounter2.keySet())) {
            return false;
        }
        return atomUniqueCounter1.keySet().equals(atomUniqueCounter2.keySet()) ? (queryMol.getElectronContainerCount() == targetMol.getElectronContainerCount() ? this.isSubgraphIdentical(queryMol, targetMol, removeHydrogen) : false) : false;
    }

    private boolean isSubgraphIdentical(IAtomContainer qMol, IAtomContainer tMol, boolean removeHydrogen) throws CDKException, IOException, CloneNotSupportedException {
        IAtomContainer mol1 = qMol.clone();
        IAtomContainer mol2 = tMol.clone();
        if (removeHydrogen) {
            mol1 = ExtAtomContainerManipulator.removeHydrogens(mol1);
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol1);
            ExtAtomContainerManipulator.aromatizeMolecule(mol1);
            mol2 = ExtAtomContainerManipulator.removeHydrogens(mol2);
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol2);
            ExtAtomContainerManipulator.aromatizeMolecule(mol2);
        }
        if (mol1.getAtomCount() != mol2.getAtomCount()) {
            return false;
        }
        Substructure mcs = new Substructure(mol1, mol2, true, true, true, false);
        mcs.setChemFilters(true, true, true);
        return mcs.isSubgraph() && !mcs.isStereoMisMatch();
    }
}

