/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping.algorithm;

import java.io.Serializable;
import java.util.Map;
import java.util.logging.Logger;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.mapping.algorithm.GameTheoryMatrix;
import uk.ac.ebi.reactionblast.mapping.algorithm.GameTheoryMax;
import uk.ac.ebi.reactionblast.mapping.algorithm.GameTheoryMin;
import uk.ac.ebi.reactionblast.mapping.algorithm.GameTheoryMixture;
import uk.ac.ebi.reactionblast.mapping.algorithm.GameTheoryRings;
import uk.ac.ebi.reactionblast.mapping.interfaces.IGameTheory;
import uk.ac.ebi.reactionblast.mapping.interfaces.IMappingAlgorithm;

public class GameTheoryFactory
implements Serializable {
    private static final long serialVersionUID = 119099989881L;
    private static final Logger LOG = Logger.getLogger(GameTheoryFactory.class.getName());

    public static synchronized IGameTheory make(IMappingAlgorithm theory, IReaction reaction, boolean removeHydrogen, Map<Integer, IAtomContainer> educts, Map<Integer, IAtomContainer> products, GameTheoryMatrix rpsh) throws Exception {
        switch (theory) {
            case MIXTURE: {
                return new GameTheoryMixture(reaction, removeHydrogen, educts, products, rpsh);
            }
            case MIN: {
                return new GameTheoryMin(reaction, removeHydrogen, educts, products, rpsh);
            }
            case MAX: {
                return new GameTheoryMax(reaction, removeHydrogen, educts, products, rpsh);
            }
            case RINGS: {
                return new GameTheoryRings(reaction, removeHydrogen, educts, products, rpsh);
            }
        }
        return null;
    }

    private GameTheoryFactory() {
    }
}

