/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.mapping;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.logging.Logger;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.graph.SimpleGraph;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.graph.BFSShortestPath;
import org.openscience.cdk.graph.MoleculeGraphs;
import org.openscience.cdk.graph.PathTools;
import org.openscience.cdk.graph.matrix.AdjacencyMatrix;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import uk.ac.ebi.reactionblast.tools.labelling.SignatureMoleculeLabeller;

public class CanonicalNumberingGenerator {
    private static final Logger LOG = Logger.getLogger(CanonicalNumberingGenerator.class.getName());
    private final IAtomContainer atomContainer;
    private final SimpleGraph simpleGraph;
    private final int[][] costMatrix;
    private final int[][] distanceMatrix;
    private final List<Integer> canonicalPermutationList;
    private final List<Integer> orbitalCanonicalLabellingList;

    private static synchronized void resetFlags(IAtomContainer atomContainer) {
        int f;
        for (f = 0; f < atomContainer.getAtomCount(); ++f) {
            atomContainer.getAtom(f).setFlag(16, false);
        }
        for (f = 0; f < atomContainer.getBondCount(); ++f) {
            atomContainer.getBond(f).setFlag(16, false);
        }
    }

    private static synchronized <T extends Comparable<? super T>> List<T> asSortedList(Collection<T> c) {
        ArrayList<T> list = new ArrayList<T>(c);
        Collections.sort(list);
        return list;
    }

    public CanonicalNumberingGenerator(IAtomContainer atomContainer) {
        this.atomContainer = new AtomContainer(atomContainer);
        this.costMatrix = AdjacencyMatrix.getMatrix(this.atomContainer);
        this.distanceMatrix = PathTools.computeFloydAPSP(this.costMatrix);
        this.simpleGraph = MoleculeGraphs.getMoleculeGraph(atomContainer);
        CanonicalNumberingGenerator.resetFlags(this.atomContainer);
        SignatureMoleculeLabeller molLabel = new SignatureMoleculeLabeller();
        int[] canonicalPermutation = molLabel.getCanonicalPermutation(atomContainer);
        this.canonicalPermutationList = this.asList(canonicalPermutation);
        TreeMap subLabels = new TreeMap();
        int counter = 0;
        for (int i : this.canonicalPermutationList) {
            IAtom atom = this.atomContainer.getAtom(i);
            List labels = !subLabels.containsKey(atom.getSymbol()) ? new ArrayList() : (List)subLabels.get(atom.getSymbol());
            Label l = new Label();
            l.atom = atom;
            l.rank = i;
            l.postion = counter++;
            labels.add(l);
            subLabels.put(atom.getSymbol(), labels);
        }
        this.orbitalCanonicalLabellingList = new ArrayList<Integer>(this.canonicalPermutationList.size());
        for (List labels : subLabels.values()) {
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (Label label : labels) {
                l.add(label.rank);
            }
            this.orbitalCanonicalLabellingList.addAll(l);
        }
    }

    private synchronized List<Integer> asList(int[] is) {
        ArrayList<Integer> intList = new ArrayList<Integer>();
        for (int index = 0; index < is.length; ++index) {
            intList.add(index, is[index]);
        }
        return intList;
    }

    public synchronized int[] getCanonicalPermutation() {
        int[] val = new int[this.canonicalPermutationList.size()];
        int index = 0;
        for (Integer i : this.canonicalPermutationList) {
            val[index++] = i;
        }
        return val;
    }

    public synchronized int[] getOrbitalCanonicalLabelling() {
        int[] val = new int[this.orbitalCanonicalLabellingList.size()];
        int index = 0;
        for (Integer i : this.orbitalCanonicalLabellingList) {
            val[index++] = i;
        }
        return val;
    }

    class Distance
    implements Comparator<Label> {
        Distance() {
        }

        @Override
        public synchronized int compare(Label t1, Label t2) {
            List<Edge> sp = BFSShortestPath.findPathBetween(CanonicalNumberingGenerator.this.simpleGraph, t1.atom, t2.atom);
            if (t1.atom == t2.atom) {
                return 0;
            }
            if (sp.isEmpty()) {
                return 99999;
            }
            if (sp.size() == 1) {
                return 1;
            }
            return -1;
        }
    }

    class Label {
        int rank;
        IAtom atom;
        int postion;

        Label() {
        }

        public synchronized String toString() {
            StringBuilder result = new StringBuilder();
            String NEW_LINE = System.getProperty("line.separator");
            result.append("Atom: ").append(this.atom.getSymbol()).append(", Rank: ").append(this.rank);
            result.append(NEW_LINE);
            return result.toString();
        }
    }
}

