/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct.layout;

import java.awt.geom.Rectangle2D;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.graphics.direct.Axis;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.layout.AbstractDirectLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;
import uk.ac.ebi.reactionblast.graphics.direct.layout.LinearMoleculeSetLayout;

public abstract class AbstractDirectReactionLayout
extends AbstractDirectLayout<IReaction> {
    protected BoundsTree reactantBoundsTree;
    protected BoundsTree productBoundsTree;
    protected Axis arrowAxis;
    protected double arrowPos;
    protected LinearMoleculeSetLayout reactantLayout;
    protected LinearMoleculeSetLayout productLayout;

    public AbstractDirectReactionLayout() {
        this(true);
    }

    public AbstractDirectReactionLayout(boolean shouldInvert) {
        this(shouldInvert, new Vector2d(1.0, 0.0));
    }

    public AbstractDirectReactionLayout(boolean shouldInvert, Vector2d moleculeAxis) {
        super(shouldInvert);
        this.reactantLayout = new LinearMoleculeSetLayout(null, shouldInvert, moleculeAxis);
        this.productLayout = new LinearMoleculeSetLayout(null, shouldInvert, moleculeAxis);
    }

    @Override
    public void setParams(Params params) {
        this.params = params;
        this.reactantLayout.setParams(params);
        this.productLayout.setParams(params);
    }

    public BoundsTree getReactantBounds() {
        return this.reactantBoundsTree;
    }

    public BoundsTree getProductBounds() {
        return this.productBoundsTree;
    }

    public Vector2d getReactantAxis() {
        return this.reactantLayout.getAxis();
    }

    public Vector2d getProductAxis() {
        return this.productLayout.getAxis();
    }

    public double getReactantAxisPos() {
        return this.reactantLayout.getAxisPosition();
    }

    public double getProductAxisPos() {
        return this.productLayout.getAxisPosition();
    }

    public Axis getArrowAxis() {
        return this.arrowAxis;
    }

    public void shiftReaction(IReaction reaction, Vector2d axis, double x, double y) {
        this.shiftMoleculeSet(reaction.getReactants(), this.reactantBoundsTree, x, y);
        this.shiftMoleculeSet(reaction.getProducts(), this.productBoundsTree, x + x * axis.x, y + y * axis.y);
    }

    public void shiftMoleculeSet(IAtomContainerSet molSet, BoundsTree molSetBoundsTree, double dx, double dy) {
        int counter = 0;
        String rootLabel = molSet.getID();
        for (IAtomContainer molecule : molSet.atomContainers()) {
            String label = rootLabel + "_" + molecule.getID() + ":" + counter;
            Rectangle2D bounds = molSetBoundsTree.get(label);
            bounds.setFrame(bounds.getCenterX() + dx, bounds.getCenterY() + dy, bounds.getWidth(), bounds.getHeight());
            GeometryTools.translate2D(molecule, dx, dy);
            ++counter;
        }
    }

    public Point2d getArrowCenter() {
        if (this.arrowAxis == Axis.X) {
            return new Point2d(this.arrowPos, this.getAxisPosition());
        }
        return new Point2d(this.getAxisPosition(), this.arrowPos);
    }

    public double getArrowPos() {
        return this.arrowPos;
    }

    public void setArrowPos(double pos) {
        this.arrowPos = pos;
    }
}

