/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import org.openscience.cdk.geometry.GeometryTools;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import uk.ac.ebi.reactionblast.graphics.direct.AbstractHighlightDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.Highlighter;
import uk.ac.ebi.reactionblast.graphics.direct.Params;

public class OutlineHighlighter
extends AbstractHighlightDrawer
implements Highlighter {
    private static final Logger LOG = Logger.getLogger(OutlineHighlighter.class.getName());
    private final Map<IAtomContainer, Color> colorMap = new HashMap<IAtomContainer, Color>();

    public OutlineHighlighter(Params params) {
        super(params);
    }

    @Override
    public void addHighlights(IAtomContainer highlightContainer, Color color) {
        this.colorMap.put(highlightContainer, color);
    }

    @Override
    public void addHighlights(List<IAtom> atoms, List<IBond> bonds) {
        IAtomContainer highlightContainer = null;
        if (atoms.size() > 0) {
            highlightContainer = atoms.get(0).getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        } else if (bonds.size() > 0) {
            highlightContainer = bonds.get(0).getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        } else {
            return;
        }
        for (IAtom atom : atoms) {
            highlightContainer.addAtom(atom);
        }
        for (IBond bond : bonds) {
            highlightContainer.addBond(bond);
        }
        this.addHighlights(highlightContainer, this.params.highlightColor);
    }

    @Override
    public void addToHighlights(Map<IAtom, Color> colorMap) {
    }

    @Override
    public void drawHighlights(IAtomContainer molecule, Graphics2D g) {
        ArrayList<IAtomContainer> highlightContainers;
        Point2d center = null;
        if (this.params.circularHighlightIsConcentric) {
            highlightContainers = new ArrayList<IAtomContainer>(this.colorMap.keySet());
            Collections.sort(highlightContainers, new Comparator<IAtomContainer>(){

                @Override
                public int compare(IAtomContainer ac0, IAtomContainer ac1) {
                    if (ac0.getAtomCount() < ac1.getAtomCount()) {
                        return 1;
                    }
                    if (ac0.getAtomCount() > ac1.getAtomCount()) {
                        return -1;
                    }
                    return 0;
                }
            });
            center = GeometryTools.get2DCenter((IAtomContainer)highlightContainers.get(highlightContainers.size() - 1));
        } else {
            highlightContainers = new ArrayList<IAtomContainer>(this.colorMap.keySet());
        }
        for (int containerIndex = 0; containerIndex < highlightContainers.size(); ++containerIndex) {
            double dim;
            double y;
            double x;
            IAtomContainer highlightContainer = (IAtomContainer)highlightContainers.get(containerIndex);
            Color savedColor = g.getColor();
            if (this.params.circularHighlightTransparentFilled) {
                g.setColor(this.getTranslucentColor(this.colorMap.get(highlightContainer)));
            } else {
                g.setColor(this.colorMap.get(highlightContainer));
            }
            if (!this.params.circularHighlightIsConcentric || center == null) {
                center = GeometryTools.get2DCenter(highlightContainer);
            }
            double maxDist = 0.0;
            for (IAtom highlightAtom : highlightContainer.atoms()) {
                double d;
                if (!molecule.contains(highlightAtom)) continue;
                Point2d point = highlightAtom.getPoint2d();
                if (point != null && (d = center.distance(point)) > maxDist) {
                    maxDist = d;
                }
                if (!this.params.circularHighlightShowAtoms) continue;
                double r = this.params.highlightRadius;
                g.fill(new Ellipse2D.Double(point.x - r, point.y - r, r * 2.0, r * 2.0));
            }
            if (highlightContainer.getAtomCount() == 1 && containerIndex == highlightContainers.size() - 1) {
                x = center.x - this.params.circularHighlightMinRadius;
                y = center.y - this.params.circularHighlightMinRadius;
                dim = 2.0 * this.params.circularHighlightMinRadius;
            } else {
                x = center.x - maxDist;
                y = center.y - maxDist;
                dim = 2.0 * maxDist;
            }
            if (this.params.circularHighlightTransparentFilled) {
                g.fill(new Ellipse2D.Double(x, y, dim, dim));
            } else {
                g.draw(new Ellipse2D.Double(x, y, dim, dim));
            }
            g.setColor(savedColor);
        }
    }

    @Override
    public void clearHighlights() {
        this.colorMap.clear();
    }
}

