/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IReaction;
import uk.ac.ebi.reactionblast.graphics.direct.AbstractDirectDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.ColorRamp;
import uk.ac.ebi.reactionblast.graphics.direct.DirectMoleculeDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.DirectReactionDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.Params;
import uk.ac.ebi.reactionblast.graphics.direct.awtlayout.AbstractAWTReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.AbstractDirectReactionLayout;
import uk.ac.ebi.reactionblast.graphics.direct.layout.BoundsTree;
import uk.ac.ebi.reactionblast.mapping.blocks.Block;
import uk.ac.ebi.reactionblast.mapping.blocks.BlockPair;
import uk.ac.ebi.reactionblast.mapping.helper.RBlastReaction;

public class DirectRBLastReactionDrawer
extends AbstractDirectDrawer {
    private static final Logger LOG = Logger.getLogger(DirectRBLastReactionDrawer.class.getName());
    private DirectReactionDrawer reactionDrawer;

    public DirectRBLastReactionDrawer(AbstractDirectReactionLayout layout) {
        this(new Params(), layout);
    }

    public DirectRBLastReactionDrawer(Params params, AbstractDirectReactionLayout layout) {
        this.setParams(params);
        this.reactionDrawer = new DirectReactionDrawer(params, layout);
    }

    public DirectRBLastReactionDrawer(Params params, AbstractDirectReactionLayout layout, AbstractAWTReactionLayout exactLayout) {
        this.setParams(params);
        this.reactionDrawer = new DirectReactionDrawer(params, layout, exactLayout);
    }

    public DirectReactionDrawer getReactionDrawer() {
        return this.reactionDrawer;
    }

    public Image drawRBlastReaction(RBlastReaction rBlastReaction, int w, int h) {
        BufferedImage image = this.makeBlankImage(w, h);
        Graphics2D g = (Graphics2D)image.getGraphics();
        this.drawRBlastReaction(rBlastReaction, w, h, g);
        g.dispose();
        return image;
    }

    public Rectangle2D drawRBlastReaction(RBlastReaction rBlastReaction, int w, int h, Graphics2D g) {
        AffineTransform originalTransform = g.getTransform();
        IReaction reaction = rBlastReaction.getReaction();
        this.reactionDrawer.getLayout().shouldInvert = true;
        Map<String, String> labelMap = this.reactionDrawer.makeLabelMap(reaction);
        BoundsTree boundsTree = this.reactionDrawer.getExactReactionBounds(reaction, g);
        ArrayList<String> labels = new ArrayList<String>(labelMap.keySet());
        Rectangle2D totalBoundingBox = boundsTree.getBounds(labels);
        boundsTree.setRoot(totalBoundingBox);
        double zoom = this.reactionDrawer.calculateZoom(w, h, totalBoundingBox);
        BoundsTree centeredBoundsTree = this.reactionDrawer.centerOn(reaction, 0.0, 0.0, boundsTree);
        totalBoundingBox = centeredBoundsTree.getBounds(labels);
        centeredBoundsTree.setRoot(totalBoundingBox);
        if (this.params.highlightSubgraphs) {
            this.highlightSubgraphs(rBlastReaction);
        }
        if (this.params.drawRS) {
            DirectMoleculeDrawer molDrawer = this.reactionDrawer.getMoleculeDrawer();
            molDrawer.addToChiralMap(rBlastReaction.getAtomStereoProductMap());
            molDrawer.addToChiralMap(rBlastReaction.getAtomStereoReactantMap());
        }
        double rxnWidth = totalBoundingBox.getWidth();
        double rxnHeight = totalBoundingBox.getHeight();
        double finalWidth = zoom * rxnWidth + (double)(2 * this.params.borderX);
        double finalHeight = zoom * rxnHeight + (double)(2 * this.params.borderY);
        this.reactionDrawer.drawReaction(reaction, centeredBoundsTree, w, h, zoom, g);
        this.drawBondChangeMarks(rBlastReaction, g);
        if (this.params.drawSubgraphBoxes) {
            this.drawSubgraphBoxes(rBlastReaction, g);
        }
        if (this.params.drawReactionID) {
            this.reactionDrawer.drawReactionID(reaction, (int)((double)w / zoom), g);
        }
        if (this.params.drawLabelPanel) {
            g.setTransform(originalTransform);
            g.translate(w / 2, h / 2);
            g.setFont(new Font(this.params.labelPanelFont, 0, this.params.labelPanelFontSize));
            AffineTransform labelTransform = new AffineTransform();
            labelTransform.scale(zoom, zoom);
            double labelGap = this.params.labelGap;
            double labelHeight = this.reactionDrawer.getMaxLabelHeight(centeredBoundsTree, labelMap, g);
            double labelShift = totalBoundingBox.getHeight() / 2.0 + labelHeight / 2.0 + labelGap;
            labelTransform.translate(0.0, labelShift);
            BoundsTree labelBoundsTree = centeredBoundsTree.transform(labelTransform);
            g.setColor(Color.BLACK);
            this.reactionDrawer.drawLabelPanel(labelMap, labelBoundsTree, g);
            finalHeight += labelHeight + labelGap;
        }
        if (this.params.shouldCrop) {
            double dX = (double)w - finalWidth;
            double dY = (double)h - finalHeight;
            int cropX = Math.max(0, (int)dX / 2);
            int cropY = Math.max(0, (int)dY / 2);
            int cropW = (int)Math.min(finalWidth, (double)w);
            int cropH = (int)Math.min(finalHeight, (double)w);
            if (cropX + cropW > w || cropY + cropH > h) {
                System.out.println("Not cropping to [" + cropX + ", " + cropY + "] " + cropW + " x " + cropH + " as " + (cropX + cropW) + " > " + w + " or " + (cropY + cropH) + " > " + h);
                return new Rectangle2D.Double(0.0, 0.0, finalWidth, finalHeight);
            }
            return new Rectangle2D.Double(cropX, cropY, cropW, cropH);
        }
        return new Rectangle2D.Double(0.0, 0.0, finalWidth, finalHeight);
    }

    public void drawSubgraphBoxes(RBlastReaction rBlastReaction, Graphics2D g) {
        List<Object> colors = this.params.colorSubgraphBoxes ? ColorRamp.getColors(rBlastReaction.getMappedSubgraphs().size()) : new ArrayList();
        int blockIndex = 0;
        for (BlockPair subgraphMapping : rBlastReaction.getMappedSubgraphs()) {
            Block productBlock = subgraphMapping.getProductBlock();
            Block reactantBlock = subgraphMapping.getReactantBlock();
            Color color = this.getColorForBlock(colors, blockIndex);
            this.drawBlockBounds(productBlock, color, g);
            this.drawBlockBounds(reactantBlock, color, g);
            if (this.params.drawSubgraphMappingLines) {
                this.drawBlockMapping(productBlock, reactantBlock, g);
            }
            ++blockIndex;
        }
    }

    public void highlightSubgraphs(RBlastReaction rBlastReaction) {
        List<Color> colors = ColorRamp.getColors(rBlastReaction.getMappedSubgraphs().size());
        int blockIndex = 0;
        for (BlockPair subgraphMapping : rBlastReaction.getMappedSubgraphs()) {
            Block productBlock = subgraphMapping.getProductBlock();
            Block reactantBlock = subgraphMapping.getReactantBlock();
            Color color = this.getColorForBlock(colors, blockIndex);
            this.highlightSubgraph(reactantBlock, color);
            this.highlightSubgraph(productBlock, color);
            ++blockIndex;
        }
    }

    private void highlightSubgraph(Block block, Color color) {
        this.reactionDrawer.highlightSubgraph(block.getAtoms(), color);
    }

    public Color getColorForBlock(List<Color> colors, int index) {
        if (colors.isEmpty() || index > colors.size() || !this.params.colorSubgraphBoxes) {
            return Color.GRAY;
        }
        return colors.get(this.getWheelIndex(index, colors.size()));
    }

    public void drawBondChangeMarks(RBlastReaction rBlastReaction, Graphics2D g) {
        if (this.params.drawBondFormedCleavedMarks) {
            List<IBond> bondCleavedReactant = rBlastReaction.getBondsCleavedInReactant();
            this.drawBondExistentialMarks(bondCleavedReactant, g);
        }
        if (this.params.drawBondOrderChangedMarks) {
            List<IBond> bondOrderChangedReactant = rBlastReaction.getBondsOrderChangedInReactant();
            this.drawBondChangeMarks(bondOrderChangedReactant, g);
        }
        if (this.params.drawBondStereoChanges) {
            List<IBond> bondStereoChangedReactant = rBlastReaction.getBondsStereoChangedInReactant();
            this.drawBondChangeMarks(bondStereoChangedReactant, g);
        }
        if (this.params.drawBondFormedCleavedMarks) {
            List<IBond> bondFormedProduct = rBlastReaction.getBondsFormedInProduct();
            this.drawBondExistentialMarks(bondFormedProduct, g);
        }
        if (this.params.drawBondOrderChangedMarks) {
            List<IBond> bondOrderChangedProduct = rBlastReaction.getBondsOrderChangedInProduct();
            this.drawBondChangeMarks(bondOrderChangedProduct, g);
        }
        if (this.params.drawBondStereoChanges) {
            List<IBond> bondStereoChangedProduct = rBlastReaction.getBondsStereoChangedInProduct();
            this.drawBondChangeMarks(bondStereoChangedProduct, g);
        }
    }

    private void drawBondExistentialMarks(List<IBond> bondsCleaved, Graphics2D g) {
        double markLength = this.params.bondMarkLength;
        for (IBond bond : bondsCleaved) {
            Point2d p1 = bond.getAtom(0).getPoint2d();
            Point2d p2 = bond.getAtom(1).getPoint2d();
            Point2d center = new Point2d(p1);
            center.interpolate(p2, 0.5);
            Vector2d bondVector = new Vector2d(p1);
            bondVector.sub(p2);
            bondVector.normalize();
            Vector2d negBondVector = new Vector2d(bondVector);
            negBondVector.negate();
            Point2d pc1 = new Point2d(center);
            pc1.scaleAdd(this.params.doubleMarkGap, bondVector, pc1);
            Point2d pc2 = new Point2d(center);
            pc2.scaleAdd(this.params.doubleMarkGap, negBondVector, pc2);
            Vector2d perp = new Vector2d(-bondVector.y, bondVector.x);
            Vector2d negPerp = new Vector2d(perp);
            negPerp.negate();
            Point2d pp11 = new Point2d(pc1);
            pp11.scaleAdd(markLength / 2.0, perp, pp11);
            Point2d pp12 = new Point2d(pc1);
            pp12.scaleAdd(markLength / 2.0, negPerp, pp12);
            this.drawLine(pp11, pp12, g);
            Point2d pp21 = new Point2d(pc2);
            pp21.scaleAdd(markLength / 2.0, perp, pp21);
            Point2d pp22 = new Point2d(pc2);
            pp22.scaleAdd(markLength / 2.0, negPerp, pp22);
            this.drawLine(pp21, pp22, g);
        }
    }

    private void drawBondChangeMarks(List<IBond> bondsChanged, Graphics2D g) {
        double markLength = this.params.bondMarkLength;
        for (IBond bond : bondsChanged) {
            Point2d p1 = bond.getAtom(0).getPoint2d();
            Point2d p2 = bond.getAtom(1).getPoint2d();
            Point2d center = new Point2d(p1);
            center.interpolate(p2, 0.5);
            Vector2d bondVector = new Vector2d(p1);
            bondVector.sub(p2);
            bondVector.normalize();
            Vector2d perp = new Vector2d(-bondVector.y, bondVector.x);
            Vector2d negPerp = new Vector2d(perp);
            negPerp.negate();
            Point2d pp1 = new Point2d(center);
            pp1.scaleAdd(markLength / 2.0, perp, pp1);
            Point2d pp2 = new Point2d(center);
            pp2.scaleAdd(markLength / 2.0, negPerp, pp2);
            this.drawLine(pp1, pp2, g);
        }
    }

    private void drawBlockMapping(Block productBlock, Block reactantBlock, Graphics2D g) {
        Point2d productCenter = productBlock.getCenterPoint();
        Point2d reactantCenter = reactantBlock.getCenterPoint();
        this.drawLine(productCenter, reactantCenter, g);
    }

    private int getWheelIndex(int index, int n) {
        int sum = 0;
        for (int i = 0; i < index; ++i) {
            sum += n / 2 + i % 2 * ((n + 1) % 2);
        }
        return sum % n;
    }

    private void drawBlockBounds(Block block, Color color, Graphics2D g) {
        Rectangle2D bounds = this.reactionDrawer.getDrawnBounds(block.getAtoms());
        if (bounds == null) {
            bounds = block.getBounds();
        }
        g.setColor(color);
        double centerX = bounds.getCenterX();
        double centerY = bounds.getCenterY();
        int w = (int)bounds.getWidth() + this.params.subgraphBoxXBorder * 2;
        int h = (int)bounds.getHeight() + this.params.subgraphBoxYBorder * 2;
        int x = (int)centerX - w / 2;
        int y = (int)centerY - h / 2;
        g.drawRect(x, y, w, h);
    }
}

