/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.reactionblast.graphics.direct;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.logging.Logger;
import javax.vecmath.Point2d;
import javax.vecmath.Vector2d;
import uk.ac.ebi.reactionblast.graphics.direct.AbstractDirectDrawer;
import uk.ac.ebi.reactionblast.graphics.direct.Params;

public class DirectArrowDrawer
extends AbstractDirectDrawer {
    private static final Vector2d X_AXIS = new Vector2d(1.0, 0.0);
    private static final Vector2d Y_AXIS = new Vector2d(0.0, 1.0);
    private static final Logger LOG = Logger.getLogger(DirectArrowDrawer.class.getName());
    private final Params params;

    public DirectArrowDrawer(Params params) {
        this.params = params;
    }

    public void drawArrow(Graphics2D g, Point2d c, Vector2d v) {
        Stroke savedStroke = g.getStroke();
        g.setStroke(new BasicStroke());
        if (this.params.drawFatArrow) {
            if (this.params.arrowType == Params.ArrowType.BIDIRECTIONAL) {
                this.drawDoubleHeadedFatArrow(g, c, v, null);
            } else {
                this.drawFatArrow(g, c, v, null);
            }
        } else {
            this.drawThinArrow(g, c, v, null);
        }
        g.setStroke(savedStroke);
    }

    public void drawFatArrow(Graphics2D g, Point2d c, Vector2d v, String text) {
        int arrowLength = this.params.arrowLength;
        int arrowHeadLength = this.params.arrowHeadLength;
        int arrowHeadIndent = this.params.arrowHeadIndent;
        int arrowBodyWidth = this.params.arrowBodyWidth;
        double arrowHeadAngleRad = Math.toRadians(this.params.arrowHeadAngle);
        double arrowHeadAngleRadPrime = Math.toRadians(360.0 - this.params.arrowHeadAngle);
        double cosA = Math.cos(arrowHeadAngleRad);
        double sinA = Math.sin(arrowHeadAngleRad);
        double cosAPrime = Math.cos(arrowHeadAngleRadPrime);
        double sinAPrime = Math.sin(arrowHeadAngleRadPrime);
        int halfLength = arrowLength / 2;
        int halfBodyWidth = arrowBodyWidth / 2;
        g.setColor(Color.BLACK);
        Vector2d nV = new Vector2d(v);
        nV.negate();
        Vector2d p = new Vector2d(v.y, -v.x);
        Vector2d nP = new Vector2d(-v.y, v.x);
        Point2d tail = new Point2d(c.x, c.y);
        tail.scaleAdd(halfLength, nV, c);
        Point2d upperTail = new Point2d(tail);
        upperTail.scaleAdd(halfBodyWidth, nP, upperTail);
        Point2d lowerTail = new Point2d(tail);
        lowerTail.scaleAdd(halfBodyWidth, p, lowerTail);
        Point2d head = new Point2d(c);
        head.scaleAdd(halfLength, v, c);
        Vector2d ccwVec = new Vector2d(cosA * nV.x + sinA * nV.y, cosA * nV.y - sinA * nV.x);
        Vector2d cwVec = new Vector2d(cosAPrime * nV.x + sinAPrime * nV.y, cosAPrime * nV.y - sinAPrime * nV.x);
        Point2d headCCW = new Point2d(head.x, head.y);
        headCCW.scaleAdd(arrowHeadLength, ccwVec, head);
        Point2d indentCCW = new Point2d(headCCW);
        indentCCW.scaleAdd(arrowHeadIndent, p, indentCCW);
        Point2d headCW = new Point2d(head.x, head.y);
        headCW.scaleAdd(arrowHeadLength, cwVec, head);
        Point2d indentCW = new Point2d(headCW);
        indentCW.scaleAdd(arrowHeadIndent, nP, indentCW);
        Path2D.Double polygon = new Path2D.Double();
        ((Path2D)polygon).moveTo(head.x, head.y);
        ((Path2D)polygon).lineTo(headCCW.x, headCCW.y);
        ((Path2D)polygon).lineTo(indentCCW.x, indentCCW.y);
        ((Path2D)polygon).lineTo(upperTail.x, upperTail.y);
        ((Path2D)polygon).lineTo(lowerTail.x, lowerTail.y);
        ((Path2D)polygon).lineTo(indentCW.x, indentCW.y);
        ((Path2D)polygon).lineTo(headCW.x, headCW.y);
        polygon.closePath();
        if (this.params.drawArrowFilled) {
            g.fill(polygon);
        } else {
            g.draw(polygon);
        }
        if (text != null) {
            this.drawText(g, text, c, v, nV);
        }
    }

    public void drawDoubleHeadedFatArrow(Graphics2D g, Point2d c, Vector2d v, String text) {
        int arrowLength = this.params.arrowLength;
        int arrowHeadLength = this.params.arrowHeadLength;
        int arrowHeadIndent = this.params.arrowHeadIndent;
        double arrowHeadAngleRad = Math.toRadians(this.params.arrowHeadAngle);
        double arrowHeadAngleRadPrime = Math.toRadians(360.0 - this.params.arrowHeadAngle);
        double cosA = Math.cos(arrowHeadAngleRad);
        double sinA = Math.sin(arrowHeadAngleRad);
        double cosAPrime = Math.cos(arrowHeadAngleRadPrime);
        double sinAPrime = Math.sin(arrowHeadAngleRadPrime);
        int halfLength = arrowLength / 2;
        g.setColor(Color.BLACK);
        Vector2d nV = new Vector2d(v);
        nV.negate();
        Vector2d p = new Vector2d(v.y, -v.x);
        Vector2d nP = new Vector2d(-v.y, v.x);
        Point2d tail = new Point2d(c.x, c.y);
        tail.scaleAdd(halfLength, nV, c);
        Point2d head = new Point2d(c);
        head.scaleAdd(halfLength, v, c);
        Vector2d ccwVec = new Vector2d(cosA * nV.x + sinA * nV.y, cosA * nV.y - sinA * nV.x);
        Vector2d nCCWVec = new Vector2d(ccwVec);
        nCCWVec.negate();
        Vector2d cwVec = new Vector2d(cosAPrime * nV.x + sinAPrime * nV.y, cosAPrime * nV.y - sinAPrime * nV.x);
        Vector2d nCWVec = new Vector2d(cwVec);
        nCWVec.negate();
        Point2d headCCW = new Point2d(head.x, head.y);
        headCCW.scaleAdd(arrowHeadLength, ccwVec, head);
        Point2d headIndentCCW = new Point2d(headCCW);
        headIndentCCW.scaleAdd(arrowHeadIndent, p, headIndentCCW);
        Point2d headCW = new Point2d(head.x, head.y);
        headCW.scaleAdd(arrowHeadLength, cwVec, head);
        Point2d headIndentCW = new Point2d(headCW);
        headIndentCW.scaleAdd(arrowHeadIndent, nP, headIndentCW);
        Point2d tailCCW = new Point2d(tail);
        tailCCW.scaleAdd(arrowHeadLength, nCWVec, tailCCW);
        Point2d tailCW = new Point2d(tail);
        tailCW.scaleAdd(arrowHeadLength, nCCWVec, tailCW);
        Point2d upperTail = new Point2d(tailCCW);
        upperTail.scaleAdd(arrowHeadIndent, p, upperTail);
        Point2d lowerTail = new Point2d(tailCW);
        lowerTail.scaleAdd(arrowHeadIndent, nP, lowerTail);
        Path2D.Double polygon = new Path2D.Double();
        ((Path2D)polygon).moveTo(head.x, head.y);
        ((Path2D)polygon).lineTo(headCCW.x, headCCW.y);
        ((Path2D)polygon).lineTo(headIndentCCW.x, headIndentCCW.y);
        ((Path2D)polygon).lineTo(upperTail.x, upperTail.y);
        ((Path2D)polygon).lineTo(tailCCW.x, tailCCW.y);
        ((Path2D)polygon).lineTo(tail.x, tail.y);
        ((Path2D)polygon).lineTo(tailCW.x, tailCW.y);
        ((Path2D)polygon).lineTo(lowerTail.x, lowerTail.y);
        ((Path2D)polygon).lineTo(headIndentCW.x, headIndentCW.y);
        ((Path2D)polygon).lineTo(headCW.x, headCW.y);
        polygon.closePath();
        if (this.params.drawArrowFilled) {
            g.fill(polygon);
        } else {
            g.draw(polygon);
        }
        if (text != null) {
            this.drawText(g, text, c, v, nV);
        }
    }

    public void drawThinArrow(Graphics2D g, Point2d c, Vector2d v, String text) {
        int arrowLength = this.params.arrowLength;
        int arrowHeadLength = this.params.arrowHeadLength;
        double arrowHeadAngleRad = Math.toRadians(this.params.arrowHeadAngle);
        double arrowHeadAngleRadPrime = Math.toRadians(360.0 - this.params.arrowHeadAngle);
        double cosA = Math.cos(arrowHeadAngleRad);
        double sinA = Math.sin(arrowHeadAngleRad);
        double cosAPrime = Math.cos(arrowHeadAngleRadPrime);
        double sinAPrime = Math.sin(arrowHeadAngleRadPrime);
        int halfLength = arrowLength / 2;
        g.setColor(Color.BLACK);
        Vector2d nV = new Vector2d(v);
        nV.negate();
        Point2d tail = new Point2d(c.x, c.y);
        tail.scaleAdd(halfLength, nV, c);
        Point2d head = new Point2d(c);
        head.scaleAdd(halfLength, v, c);
        Vector2d ccwVec = new Vector2d(cosA * nV.x + sinA * nV.y, cosA * nV.y - sinA * nV.x);
        Vector2d cwVec = new Vector2d(cosAPrime * nV.x + sinAPrime * nV.y, cosAPrime * nV.y - sinAPrime * nV.x);
        Point2d headCCW = new Point2d(head.x, head.y);
        headCCW.scaleAdd(arrowHeadLength, ccwVec, head);
        Point2d headCW = new Point2d(head.x, head.y);
        headCW.scaleAdd(arrowHeadLength, cwVec, head);
        g.draw(new Line2D.Double(tail.x, tail.y, head.x, head.y));
        g.draw(new Line2D.Double(head.x, head.y, headCCW.x, headCCW.y));
        g.draw(new Line2D.Double(head.x, head.y, headCW.x, headCW.y));
        if (text != null) {
            this.drawText(g, text, c, v, nV);
        }
    }

    private void drawText(Graphics2D g, String text, Point2d c, Vector2d v, Vector2d nV) {
        AffineTransform originalTransform = g.getTransform();
        double angle = this.getAngle(v);
        Rectangle2D textBounds = this.getTextBounds(g, text);
        double distance = textBounds.getWidth() / 2.0;
        Point2d start = new Point2d(c.x, c.y);
        if (angle < Math.toRadians(90.0) || angle > Math.toRadians(270.0)) {
            start.scaleAdd(distance, nV, c);
        } else {
            start.scaleAdd(distance, v, c);
            double angDeg = (180.0 + Math.toDegrees(angle)) % 360.0;
            angle = Math.toRadians(angDeg);
        }
        g.translate(start.x, start.y);
        g.rotate(angle);
        Font font = g.getFont();
        FontRenderContext frc = g.getFontRenderContext();
        GlyphVector gv = font.createGlyphVector(frc, text);
        int length = gv.getNumGlyphs();
        for (int i = 0; i < length; ++i) {
            g.fill(gv.getGlyphOutline(i));
        }
        g.rotate(Math.PI * 2 - angle);
        g.setTransform(originalTransform);
    }

    private double getAngle(Vector2d v) {
        double xAngle = X_AXIS.angle(v);
        double yAngle = Y_AXIS.angle(v);
        if (xAngle < Math.toRadians(90.0)) {
            if (yAngle < Math.toRadians(90.0)) {
                return xAngle;
            }
            return Math.toRadians(360.0) - xAngle;
        }
        return Math.toRadians(90.0) + yAngle;
    }
}

