/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.priority.descriptor;

import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.TreeSet;
import java.util.logging.Logger;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.Priority;
import uk.ac.ebi.centres.PriorityRule;
import uk.ac.ebi.centres.descriptor.General;
import uk.ac.ebi.centres.priority.AbstractPriorityRule;
import uk.ac.ebi.centres.priority.access.DescriptorAccessor;
import uk.ac.ebi.centres.priority.descriptor.DescriptorList;

public class PairRule<A>
extends AbstractPriorityRule<A> {
    private static final Logger LOG = Logger.getLogger(PairRule.class.getName());
    private final DescriptorAccessor<A> accessor;

    private static <T> List<List<T>> permutate(List<List<T>> uncombinedList) {
        ArrayList<List<T>> list = new ArrayList<List<T>>();
        for (List<T> sublist : uncombinedList) {
            if (sublist.size() <= 1) continue;
            Collection<List<T>> tmp = Collections2.permutations(sublist);
            sublist.clear();
            sublist.addAll(tmp);
        }
        int[] index = new int[uncombinedList.size()];
        int combinations = PairRule.combinations(uncombinedList) - 1;
        for (int i = 0; i < index.length; ++i) {
            index[i] = 0;
        }
        ArrayList<T> combination = new ArrayList<T>();
        for (int m = 0; m < index.length; ++m) {
            T o = uncombinedList.get(m).get(index[m]);
            if (o instanceof Collection) {
                combination.addAll((Collection)o);
                continue;
            }
            combination.add(o);
        }
        list.add(combination);
        for (int k = 0; k < combinations; ++k) {
            combination = new ArrayList();
            boolean found = false;
            for (int l = index.length - 1; l >= 0 && !found; --l) {
                int currentListSize = uncombinedList.get(l).size();
                if (index[l] < currentListSize - 1) {
                    int n = l;
                    index[n] = index[n] + 1;
                    found = true;
                    continue;
                }
                index[l] = 0;
            }
            for (int m = 0; m < index.length; ++m) {
                T o = uncombinedList.get(m).get(index[m]);
                if (o instanceof Collection) {
                    combination.addAll((Collection)o);
                    continue;
                }
                combination.add(o);
            }
            list.add(combination);
        }
        return list;
    }

    private static <T> int combinations(List<List<T>> list) {
        int count = 1;
        for (List<T> current : list) {
            count *= current.size();
        }
        return count;
    }

    public PairRule(DescriptorAccessor<A> accessor) {
        super(PriorityRule.Type.GEOMETRICAL);
        this.accessor = accessor;
    }

    protected NavigableSet<DescriptorList> generate(Ligand<A> ligand) {
        LinkedList<Ligand<A>> queue = Lists.newLinkedList();
        queue.add(ligand);
        return this.generate(queue);
    }

    @Override
    public int recursiveCompare(Ligand<A> o1, Ligand<A> o2) {
        return this.compare(o1, o2);
    }

    protected NavigableSet<DescriptorList> generate(Queue<Ligand<A>> queue) {
        TreeSet<DescriptorList> lists = new TreeSet<DescriptorList>();
        DescriptorList descriptors = new DescriptorList(null, General.NONE, General.UNSPECIFIED, General.UNKNOWN);
        while (!queue.isEmpty()) {
            Ligand<A> ligand = queue.poll();
            descriptors.add(this.accessor.getDescriptor(ligand));
            List<Ligand<A>> ligands = ligand.getLigands();
            Priority priority = this.prioritise(ligands);
            if (priority.isUnique().booleanValue()) {
                for (Ligand<A> ligand2 : ligands) {
                    queue.add(ligand2);
                }
                continue;
            }
            for (List list : PairRule.permutate(this.getSorter().getGroups(ligands))) {
                LinkedList<Ligand<A>> subqueue = new LinkedList<Ligand<A>>(queue);
                subqueue.addAll(list);
                lists.addAll(descriptors.append(this.generate(subqueue)));
            }
            queue.clear();
        }
        if (lists.isEmpty()) {
            lists.add(descriptors);
        }
        return lists;
    }

    @Override
    public int compare(Ligand<A> o1, Ligand<A> o2) {
        Iterator<DescriptorList> list1It = this.generate(o1).iterator();
        Iterator<DescriptorList> list2It = this.generate(o2).iterator();
        while (list1It.hasNext() && list2It.hasNext()) {
            int value = list1It.next().compareTo(list2It.next());
            if (value == 0) continue;
            return value;
        }
        return 0;
    }
}

