/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.io;

import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.ac.ebi.centres.Digraph;
import uk.ac.ebi.centres.Ligand;

public abstract class CytoscapeWriter<A>
implements Closeable {
    private final Digraph<A> digraph;
    private Writer sif;
    private File folder;
    private final Map<String, Map<String, String>> attributes = new HashMap<String, Map<String, String>>();

    public CytoscapeWriter(File folder, Digraph<A> digraph) throws IOException {
        this.digraph = digraph;
        if (folder.exists() && !folder.isDirectory()) {
            throw new IllegalArgumentException("Folder should be a directory");
        }
        if (!folder.exists() && !folder.mkdirs()) {
            throw new IllegalArgumentException("Unable to create folder");
        }
        this.folder = folder;
        this.sif = new FileWriter(new File(folder, folder.getName().replace(" ", "-") + ".sif"));
    }

    public void writeSif() throws IOException {
        this.write(this.digraph.getProximal(), "1");
    }

    public void writeAttributes() throws IOException {
        for (Map.Entry<String, Map<String, String>> entry : this.attributes.entrySet()) {
            FileWriter attributeWriter = new FileWriter(new File(this.folder, entry.getKey() + ".noa"));
            Throwable throwable = null;
            try {
                attributeWriter.write(entry.getKey().replaceAll(" ", ".") + " (class=String)" + "\n");
                for (Map.Entry<String, String> nodeEntry : entry.getValue().entrySet()) {
                    attributeWriter.write(nodeEntry.getKey() + " = " + nodeEntry.getValue() + "\n");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (attributeWriter == null) continue;
                if (throwable != null) {
                    try {
                        attributeWriter.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                attributeWriter.close();
            }
        }
    }

    private void write(List<Ligand<A>> ligands, String sourceId) throws IOException {
        for (int i = 0; i < ligands.size(); ++i) {
            Ligand<A> ligand = ligands.get(i);
            String targetId = sourceId + Integer.toString(i + 1);
            this.sif.write(sourceId + "\t->\t" + targetId + "\n");
            HashMap<String, String> map = new HashMap<String, String>();
            this.mapAttributes(ligand.getAtom(), map);
            for (Map.Entry e : map.entrySet()) {
                if (!this.attributes.containsKey(e.getKey())) {
                    this.attributes.put((String)e.getKey(), new HashMap());
                }
                this.attributes.get(e.getKey()).put(targetId, (String)e.getValue());
            }
            this.write(ligands.get(i).getLigands(), targetId);
        }
    }

    public abstract void mapAttributes(A var1, Map<String, String> var2);

    @Override
    public void close() throws IOException {
        this.sif.close();
    }
}

