/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.graph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import uk.ac.ebi.centres.ConnectionProvider;
import uk.ac.ebi.centres.DescriptorManager;
import uk.ac.ebi.centres.Digraph;
import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.MutableDescriptor;
import uk.ac.ebi.centres.exception.WarpCoreEjection;
import uk.ac.ebi.centres.graph.Arc;
import uk.ac.ebi.centres.graph.DefaultDescriptorManager;
import uk.ac.ebi.centres.ligand.NonterminalLigand;
import uk.ac.ebi.centres.ligand.TerminalLigand;

public abstract class AbstractDigraph<A>
implements Digraph<A>,
ConnectionProvider<A> {
    private Ligand<A> root;
    private ArcMap arcs = new ArcMap();
    private ListMultimap<A, Ligand<A>> ligandMap = ArrayListMultimap.create();
    private DescriptorManager<A> manager;

    public AbstractDigraph(Ligand<A> root) {
        this(root, new DefaultDescriptorManager());
    }

    public AbstractDigraph(Ligand<A> root, DescriptorManager<A> manager) {
        if (root == null) {
            throw new IllegalArgumentException("Root cannot be null!");
        }
        this.root = root;
        this.manager = manager;
    }

    @Override
    public Ligand<A> getRoot() {
        return this.root;
    }

    @Override
    public List<Ligand<A>> getProximal() {
        return this.root.getLigands();
    }

    @Override
    public List<Ligand<A>> getLigands(A atom) {
        return this.ligandMap.get(atom);
    }

    @Override
    public void reroot(Ligand<A> ligand) {
        this.root = ligand;
        ligand.reset();
        LinkedList queue = new LinkedList();
        Arc arc = this.arcs.getForHead(ligand);
        while (arc != null) {
            this.arcs.remove(arc);
            Arc next = this.arcs.getForHead(arc.getTail());
            arc.transpose();
            queue.add(arc);
            arc = next;
        }
        for (Arc arc2 : queue) {
            this.arcs.add(arc2);
        }
        ligand.setParent(ligand.getAtom());
    }

    @Override
    public void build() {
        if (this.root == null) {
            throw new IllegalArgumentException("Attempting build without a root");
        }
        LinkedList queue = new LinkedList();
        queue.addAll(this.root.getLigands());
        while (!queue.isEmpty()) {
            queue.addAll(((Ligand)queue.poll()).getLigands());
        }
    }

    @Override
    public List<Arc<A>> getArcs(Ligand<A> ligand) {
        return this.arcs.getForTail(ligand);
    }

    @Override
    public Arc<A> getParentArc(Ligand<A> ligand) {
        return this.arcs.getForHead(ligand);
    }

    @Override
    public List<Ligand<A>> getLigands(Ligand<A> ligand) {
        List ligands = this.arcs.getHeads(ligand);
        if (this.ligandMap.size() > 10000) {
            throw new WarpCoreEjection();
        }
        if (!ligands.isEmpty()) {
            return ligands;
        }
        for (A atom : this.getConnected(ligand.getAtom())) {
            if (ligand.isParent(atom).booleanValue()) continue;
            MutableDescriptor descriptor = this.manager.getDescriptor(atom);
            NonterminalLigand neighbour = ligand.isVisited(atom) != false ? new TerminalLigand<A>(this, descriptor, ligand.getVisited(), atom, ligand.getAtom(), ligand.getDistanceFromRoot() + 1) : new NonterminalLigand<A>(this, descriptor, ligand.getVisited(), atom, ligand.getAtom(), ligand.getDistanceFromRoot() + 1);
            this.arcs.add(this.newArc(ligand, neighbour));
            this.ligandMap.put(atom, neighbour);
            ligands.add(neighbour);
            int order = this.getOrder(ligand.getAtom(), atom);
            if (order <= 1) continue;
            for (int i = 1; i < order; ++i) {
                TerminalLigand<A> ghost = new TerminalLigand<A>(this, descriptor, ligand.getVisited(), atom, ligand.getAtom(), ligand.getDistanceFromRoot() + 1);
                this.arcs.add(this.newArc(ligand, ghost));
                this.ligandMap.put(atom, ghost);
                ligands.add(ghost);
            }
            this.getLigands(neighbour);
            TerminalLigand<A> ghost = new TerminalLigand<A>(this, descriptor, ligand.getVisited(), ligand.getAtom(), atom, ligand.getDistanceFromRoot() + 1);
            this.arcs.add(this.newArc(neighbour, ghost));
            this.ligandMap.put(ligand.getAtom(), ghost);
        }
        return ligands;
    }

    public abstract Collection<A> getConnected(A var1);

    public abstract int getOrder(A var1, A var2);

    public abstract int getDepth(A var1, A var2);

    private Arc<A> newArc(Ligand<A> tail, Ligand<A> head) {
        return new Arc<A>(tail, head, this.manager.getDescriptor(tail.getAtom(), head.getAtom()), this.getDepth(tail.getAtom(), head.getAtom()));
    }

    @Override
    public void dispose() {
        this.ligandMap.clear();
        this.arcs.tails.clear();
        this.arcs.heads.clear();
        this.root = null;
        this.arcs = null;
        this.ligandMap = null;
        this.manager = null;
    }

    class ArcMap {
        private final ListMultimap<Ligand<A>, Arc<A>> tails = ArrayListMultimap.create();
        private final Map<Ligand<A>, Arc<A>> heads = new HashMap();

        ArcMap() {
        }

        public void remove(Arc<A> arc) {
            this.tails.remove(arc.getTail(), arc);
            this.heads.remove(arc.getHead());
        }

        public void add(Arc<A> arc) {
            this.tails.put(arc.getTail(), arc);
            if (this.heads.containsKey(arc.getHead())) {
                System.err.println("Key clash!");
            }
            this.heads.put(arc.getHead(), arc);
        }

        public Arc<A> getForHead(Ligand<A> head) {
            return this.heads.get(head);
        }

        public List<Arc<A>> getForTail(Ligand<A> tail) {
            return this.tails.get(tail);
        }

        public List<Ligand<A>> getHeads(Ligand<A> tail) {
            List arcs = this.tails.get(tail);
            ArrayList ligands = new ArrayList(arcs.size());
            for (Arc arc : arcs) {
                ligands.add(arc.getHead());
            }
            return ligands;
        }

        public Ligand<A> getTail(Ligand<A> head) {
            Arc arc = this.getForHead(head);
            if (arc == null) {
                throw new NoSuchElementException("No tail for provided head");
            }
            return arc.getTail();
        }
    }
}

