/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ebi.centres.calculator;

import uk.ac.ebi.centres.Ligand;
import uk.ac.ebi.centres.calculator.AbstractSignCalculator;

public abstract class TwoDimensionalSignCalculator<A>
extends AbstractSignCalculator<A> {
    @Override
    public int getSign(Ligand<A> a1, Ligand<A> a2, Ligand<A> a3, Ligand<A> a4) {
        if (a1.getDepth() == 0 && a2.getDepth() == 0 && a3.getDepth() == 0 && a4.getDepth() == 0) {
            return 0;
        }
        double[][] matrix = new double[][]{{this.getX(a1.getAtom()), this.getY(a1.getAtom()), 1.0, a1.getDepth()}, {this.getX(a2.getAtom()), this.getY(a2.getAtom()), 1.0, a2.getDepth()}, {this.getX(a3.getAtom()), this.getY(a3.getAtom()), 1.0, a3.getDepth()}, {this.getX(a4.getAtom()), this.getY(a4.getAtom()), 1.0, a4.getDepth()}};
        return (int)Math.signum(this.determinant(matrix));
    }

    @Override
    public double[] toVector(A base, A atom) {
        return new double[]{this.getX(base) - this.getX(base), this.getY(atom) - this.getY(atom)};
    }

    @Override
    public int getSign(A a1, A a2, A a3) {
        double[][] matrix = new double[][]{{this.getX(a1), this.getY(a1), 1.0}, {this.getX(a2), this.getY(a2), 1.0}, {this.getX(a3), this.getY(a3), 1.0}};
        double determinant = this.determinant(matrix);
        return Math.abs(determinant) < 0.2 ? 0 : (int)Math.signum(determinant);
    }
}

