/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.tools;

import java.text.SimpleDateFormat;
import java.util.TimeZone;

public class TimeManager {
    private double startTime;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");

    public TimeManager() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        this.startTime = System.currentTimeMillis();
    }

    public synchronized double getElapsedTimeInHours() {
        double currentTime = System.currentTimeMillis();
        return (currentTime - this.startTime) / 3600000.0;
    }

    public synchronized double getElapsedTimeInMinutes() {
        double currentTime = System.currentTimeMillis();
        return (currentTime - this.startTime) / 60000.0;
    }

    public synchronized double getElapsedTimeInSeconds() {
        double currentTime = System.currentTimeMillis();
        return (currentTime - this.startTime) / 1000.0;
    }

    public synchronized double getElapsedTimeInMilliSeconds() {
        double currentTime = System.currentTimeMillis();
        return currentTime - this.startTime;
    }
}

