/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.tools;

import java.io.Serializable;

public class IterationManager
implements Serializable {
    private static final long serialVersionUID = 396239639826981L;
    private int max;
    private int counter = 0;
    private int coverage = 250;
    private final int limit;

    public IterationManager() {
        this(Integer.MAX_VALUE);
    }

    public IterationManager(int maxIteration) {
        this.max = maxIteration;
        this.limit = this.max * this.coverage;
    }

    public synchronized int getCounter() {
        return this.counter;
    }

    public synchronized void increment() {
        ++this.counter;
    }

    public synchronized void decrement() {
        --this.counter;
    }

    public synchronized boolean isMaxIteration() {
        return this.getCounter() > this.limit;
    }

    public synchronized int getCoverage() {
        return this.coverage;
    }

    public synchronized void setCoverage(int coverage) {
        this.coverage = coverage;
    }

    public int getIterationLimit() {
        return this.limit;
    }
}

