/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.ringsearch.SSSRFinder;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.tools.ExtAtomContainerManipulator;

public class MoleculeInitializer {
    private static final ILoggingTool Logger = LoggingToolFactory.createLoggingTool(MoleculeInitializer.class);

    public static synchronized void initializeMolecule(IAtomContainer atomContainer) throws CDKException {
        String SMALLEST_RING_SIZE = "SMALLEST_RING_SIZE";
        if (!(atomContainer instanceof IQueryAtomContainer)) {
            HashMap<String, Integer> valencesTable = new HashMap<String, Integer>();
            valencesTable.put("H", 1);
            valencesTable.put("Li", 1);
            valencesTable.put("Be", 2);
            valencesTable.put("B", 3);
            valencesTable.put("C", 4);
            valencesTable.put("N", 5);
            valencesTable.put("O", 6);
            valencesTable.put("F", 7);
            valencesTable.put("Na", 1);
            valencesTable.put("Mg", 2);
            valencesTable.put("Al", 3);
            valencesTable.put("Si", 4);
            valencesTable.put("P", 5);
            valencesTable.put("S", 6);
            valencesTable.put("Cl", 7);
            valencesTable.put("K", 1);
            valencesTable.put("Ca", 2);
            valencesTable.put("Ga", 3);
            valencesTable.put("Ge", 4);
            valencesTable.put("As", 5);
            valencesTable.put("Se", 6);
            valencesTable.put("Br", 7);
            valencesTable.put("Rb", 1);
            valencesTable.put("Sr", 2);
            valencesTable.put("In", 3);
            valencesTable.put("Sn", 4);
            valencesTable.put("Sb", 5);
            valencesTable.put("Te", 6);
            valencesTable.put("I", 7);
            valencesTable.put("Cs", 1);
            valencesTable.put("Ba", 2);
            valencesTable.put("Tl", 3);
            valencesTable.put("Pb", 4);
            valencesTable.put("Bi", 5);
            valencesTable.put("Po", 6);
            valencesTable.put("At", 7);
            valencesTable.put("Fr", 1);
            valencesTable.put("Ra", 2);
            valencesTable.put("Cu", 2);
            valencesTable.put("Mn", 2);
            valencesTable.put("Co", 2);
            AllRingsFinder arf = new AllRingsFinder();
            IRingSet allRings = null;
            try {
                allRings = arf.findAllRings(atomContainer);
            }
            catch (CDKException e) {
                Logger.warn(e.toString());
            }
            IRingSet sssr = new SSSRFinder(atomContainer).findEssentialRings();
            for (IAtom atom : atomContainer.atoms()) {
                if (allRings != null && allRings.contains(atom)) {
                    atom.setFlag(2, true);
                    atom.setFlag(8, false);
                    ArrayList<Integer> ringsizes = new ArrayList<Integer>();
                    IRingSet currentRings = allRings.getRings(atom);
                    int min = 0;
                    for (int i = 0; i < currentRings.getAtomContainerCount(); ++i) {
                        int size = currentRings.getAtomContainer(i).getAtomCount();
                        if (min > size) {
                            min = size;
                        }
                        ringsizes.add(size);
                    }
                    Collections.sort(ringsizes);
                    atom.setProperty("cdk:RingSizes", ringsizes);
                    atom.setProperty("cdk:SmallestRings", sssr.getRings(atom));
                    atom.setProperty(SMALLEST_RING_SIZE, min);
                } else {
                    atom.setFlag(2, false);
                    atom.setFlag(8, true);
                    atom.setProperty(SMALLEST_RING_SIZE, 0);
                }
                int hCount = Objects.equals(atom.getImplicitHydrogenCount(), CDKConstants.UNSET) ? 0 : atom.getImplicitHydrogenCount();
                List<IAtom> connectedAtoms = atomContainer.getConnectedAtomsList(atom);
                int total = hCount + connectedAtoms.size();
                for (IAtom connectedAtom : connectedAtoms) {
                    if (!connectedAtom.getSymbol().equals("H")) continue;
                    ++hCount;
                }
                atom.setProperty("cdk:TotalConnections", total);
                atom.setProperty("cdk:TotalHydrogenCount", hCount);
                if (valencesTable.get(atom.getSymbol()) == null) continue;
                int formalCharge = Objects.equals(atom.getFormalCharge(), CDKConstants.UNSET) ? 0 : atom.getFormalCharge();
                atom.setValency((Integer)valencesTable.get(atom.getSymbol()) - formalCharge);
            }
            for (IBond bond : atomContainer.bonds()) {
                if (allRings == null || allRings.getRings(bond).getAtomContainerCount() <= 0) continue;
                bond.setFlag(2, true);
                bond.setFlag(8, false);
            }
            for (IAtom atom : atomContainer.atoms()) {
                List<IAtom> connectedAtoms = atomContainer.getConnectedAtomsList(atom);
                int counter = 0;
                for (IAtom connectedAtom : connectedAtoms) {
                    IAtom any = connectedAtom;
                    if (!any.getFlag(2)) continue;
                    ++counter;
                }
                atom.setProperty("cdk:RingConnections", counter);
            }
            ExtAtomContainerManipulator.aromatizeMolecule(atomContainer);
        }
    }

    public static synchronized boolean testIsSubgraphHeuristics(IAtomContainer ac1, IAtomContainer ac2, boolean shouldMatchBonds) {
        int val;
        int i;
        int ac1SingleBondCount = 0;
        int ac1DoubleBondCount = 0;
        int ac1TripleBondCount = 0;
        int ac1AromaticBondCount = 0;
        int ac2SingleBondCount = 0;
        int ac2DoubleBondCount = 0;
        int ac2TripleBondCount = 0;
        int ac2AromaticBondCount = 0;
        if (shouldMatchBonds) {
            IBond bond;
            for (int i2 = 0; i2 < ac1.getBondCount(); ++i2) {
                bond = ac1.getBond(i2);
                if (bond instanceof IQueryBond) continue;
                if (bond.getFlag(32)) {
                    ++ac1AromaticBondCount;
                    continue;
                }
                if (bond.getOrder() == IBond.Order.SINGLE) {
                    ++ac1SingleBondCount;
                    continue;
                }
                if (bond.getOrder() == IBond.Order.DOUBLE) {
                    ++ac1DoubleBondCount;
                    continue;
                }
                if (bond.getOrder() != IBond.Order.TRIPLE) continue;
                ++ac1TripleBondCount;
            }
            for (int indexI = 0; indexI < ac2.getBondCount(); ++indexI) {
                bond = ac2.getBond(indexI);
                if (bond.getFlag(32)) {
                    ++ac2AromaticBondCount;
                    continue;
                }
                if (bond.getOrder() == IBond.Order.SINGLE) {
                    ++ac2SingleBondCount;
                    continue;
                }
                if (bond.getOrder() == IBond.Order.DOUBLE) {
                    ++ac2DoubleBondCount;
                    continue;
                }
                if (bond.getOrder() != IBond.Order.TRIPLE) continue;
                ++ac2TripleBondCount;
            }
            if (ac2SingleBondCount < ac1SingleBondCount) {
                return false;
            }
            if (ac2AromaticBondCount < ac1AromaticBondCount) {
                return false;
            }
            if (ac2DoubleBondCount < ac1DoubleBondCount) {
                return false;
            }
            if (ac2TripleBondCount < ac1TripleBondCount) {
                return false;
            }
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (i = 0; i < ac1.getAtomCount(); ++i) {
            IAtom atom = ac1.getAtom(i);
            if (atom instanceof IQueryAtom) continue;
            if (map.containsKey(atom.getSymbol())) {
                val = (Integer)map.get(atom.getSymbol()) + 1;
                map.put(atom.getSymbol(), val);
                continue;
            }
            map.put(atom.getSymbol(), 1);
        }
        for (i = 0; i < ac2.getAtomCount(); ++i) {
            IAtom atom = ac2.getAtom(i);
            if (!map.containsKey(atom.getSymbol())) continue;
            val = (Integer)map.get(atom.getSymbol()) - 1;
            if (val > 0) {
                map.put(atom.getSymbol(), val);
                continue;
            }
            map.remove(atom.getSymbol());
        }
        return map.isEmpty();
    }

    private static enum RingSet {
        SmallestSetOfSmallestRings{

            @Override
            IRingSet ringSet(IAtomContainer m) {
                return new SSSRFinder(m).findSSSR();
            }
        }
        ,
        EssentialRings{

            @Override
            IRingSet ringSet(IAtomContainer m) {
                return new SSSRFinder(m).findEssentialRings();
            }
        }
        ,
        RelevantRings{

            @Override
            IRingSet ringSet(IAtomContainer m) {
                return new SSSRFinder(m).findRelevantRings();
            }
        };


        abstract IRingSet ringSet(IAtomContainer var1);
    }
}

