/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.exception.Intractable;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.filters.ChemicalFilters;
import org.openscience.smsd.filters.IChemicalFilter;
import org.openscience.smsd.filters.Sotter;

public final class StereoFilter
extends Sotter
implements IChemicalFilter<Double> {
    private final List<Double> stereoScore;
    private final ChemicalFilters chemfilter;

    StereoFilter(ChemicalFilters chemfilter) {
        this.chemfilter = chemfilter;
        this.stereoScore = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public synchronized Double sortResults(Map<Integer, AtomAtomMapping> allStereoAtomMCS, Map<Integer, Double> stereoScoreMap) throws CDKException {
        this.getStereoBondChargeMatch(stereoScoreMap, allStereoAtomMCS);
        Map<Integer, Double> sortedStereoScoreMap = StereoFilter.sortMapByValueInDescendingOrder(stereoScoreMap);
        double highestStereoScore = sortedStereoScoreMap.isEmpty() ? 0.0 : sortedStereoScoreMap.values().iterator().next();
        return highestStereoScore;
    }

    @Override
    public synchronized List<Double> getScores() {
        return Collections.unmodifiableList(this.stereoScore);
    }

    @Override
    public synchronized void clearScores() {
        this.stereoScore.clear();
    }

    @Override
    public synchronized void addScore(int counter, Double score) {
        this.stereoScore.add(counter, score);
    }

    @Override
    public synchronized void fillMap(Map<Integer, Double> stereoScoreMap) {
        int Index2 = 0;
        for (Double score : this.stereoScore) {
            stereoScoreMap.put(Index2, score);
            ++Index2;
        }
    }

    private synchronized boolean getStereoBondChargeMatch(Map<Integer, Double> stereoScoreMap, Map<Integer, AtomAtomMapping> allStereoAtomMCS) throws CDKException {
        boolean stereoMatchFlag = false;
        for (Integer Key2 : allStereoAtomMCS.keySet()) {
            try {
                double score = 0.0;
                AtomAtomMapping atomMapMCS = allStereoAtomMCS.get(Key2);
                double atomScore = this.getAtomScore(score, atomMapMCS, this.chemfilter.getQuery(), this.chemfilter.getTarget());
                Map<IBond, IBond> bondMaps = this.makeBondMapsOfAtomMaps(this.chemfilter.getQuery(), this.chemfilter.getTarget(), atomMapMCS);
                double ringScore = 0.0;
                if (this.chemfilter.getQuery().getBondCount() > 1 && this.chemfilter.getTarget().getBondCount() > 1 && !(this.chemfilter.getQuery() instanceof IQueryAtomContainer) && !(this.chemfilter.getTarget() instanceof IQueryAtomContainer)) {
                    List<IAtomContainer> subgraphRList = this.getMappedFragment(this.chemfilter.getQuery(), atomMapMCS.getMappingsByAtoms().keySet());
                    double rscore = this.getRingMatchScore(subgraphRList);
                    List<IAtomContainer> subgraphPList = this.getMappedFragment(this.chemfilter.getTarget(), atomMapMCS.getMappingsByAtoms().values());
                    double pscore = this.getRingMatchScore(subgraphPList);
                    ringScore = rscore + pscore;
                }
                double bondScore = this.getBondScore(score, bondMaps);
                score = atomScore + ringScore + bondScore;
                if (!stereoMatchFlag) {
                    stereoMatchFlag = true;
                }
                stereoScoreMap.put(Key2, score);
            }
            catch (CloneNotSupportedException ex) {
                Logger.getLogger(StereoFilter.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return stereoMatchFlag;
    }

    private synchronized Map<IBond, IBond> makeBondMapsOfAtomMaps(IAtomContainer ac1, IAtomContainer ac2, AtomAtomMapping mappings) {
        HashMap<IBond, IBond> bondbondMappingMap = new HashMap<IBond, IBond>();
        for (Map.Entry<IAtom, IAtom> map1 : mappings.getMappingsByAtoms().entrySet()) {
            for (Map.Entry<IAtom, IAtom> map2 : mappings.getMappingsByAtoms().entrySet()) {
                if (map1.getKey() == map2.getKey()) continue;
                IBond bond1 = ac1.getBond(map1.getKey(), map2.getKey());
                IBond bond2 = ac2.getBond(map1.getValue(), map2.getValue());
                if (bond1 == null || bond2 == null || bondbondMappingMap.containsKey(bond1)) continue;
                bondbondMappingMap.put(bond1, bond2);
            }
        }
        return bondbondMappingMap;
    }

    private synchronized double getAtomScore(double scoreGlobal, AtomAtomMapping atomMapMCS, IAtomContainer reactant, IAtomContainer product) {
        double score = scoreGlobal;
        for (Map.Entry<IAtom, IAtom> mappings : atomMapMCS.getMappingsByAtoms().entrySet()) {
            IAtom rAtom = mappings.getKey();
            IAtom pAtom = mappings.getValue();
            int rHCount = 0;
            int pHCount = 0;
            double rBO = reactant.getBondOrderSum(rAtom);
            double pBO = product.getBondOrderSum(pAtom);
            if (rAtom.getImplicitHydrogenCount() != null) {
                rHCount = rAtom.getImplicitHydrogenCount();
            }
            if (pAtom.getImplicitHydrogenCount() != null) {
                pHCount = pAtom.getImplicitHydrogenCount();
            }
            int HScore = Math.abs(rHCount - pHCount);
            double BOScore = Math.abs(rBO - pBO);
            score = rHCount != pHCount ? (score -= (double)HScore) : (score += (double)HScore);
            score = rBO != pBO ? (score -= BOScore) : (score += BOScore);
            if (!Objects.equals(rAtom.getFormalCharge(), pAtom.getFormalCharge())) continue;
            score += 5.0;
        }
        return score;
    }

    private synchronized double getBondScore(double scoreGlobal, Map<IBond, IBond> bondMaps) {
        double score = scoreGlobal;
        for (Map.Entry<IBond, IBond> matchedBonds : bondMaps.entrySet()) {
            IBond RBond = matchedBonds.getKey();
            IBond PBond = matchedBonds.getValue();
            score += this.getBondTypeMatches(RBond, PBond);
        }
        return score;
    }

    private synchronized double getBondTypeMatches(IBond queryBond, IBond targetBond) {
        double score = 0.0;
        if (targetBond instanceof IQueryBond && queryBond instanceof IBond) {
            IQueryBond bond = (IQueryBond)targetBond;
            IQueryAtom atom1 = (IQueryAtom)targetBond.getAtom(0);
            IQueryAtom atom2 = (IQueryAtom)targetBond.getAtom(1);
            if (bond.matches(queryBond)) {
                if (atom1.matches(queryBond.getAtom(0)) && atom2.matches(queryBond.getAtom(1)) || atom1.matches(queryBond.getAtom(1)) && atom2.matches(queryBond.getAtom(0))) {
                    score += 4.0;
                }
            } else {
                score -= 4.0;
            }
        } else if (queryBond instanceof IQueryBond && targetBond instanceof IBond) {
            IQueryBond bond = (IQueryBond)queryBond;
            IQueryAtom atom1 = (IQueryAtom)queryBond.getAtom(0);
            IQueryAtom atom2 = (IQueryAtom)queryBond.getAtom(1);
            if (bond.matches(targetBond)) {
                if (atom1.matches(targetBond.getAtom(0)) && atom2.matches(targetBond.getAtom(1)) || atom1.matches(targetBond.getAtom(1)) && atom2.matches(targetBond.getAtom(0))) {
                    score += 4.0;
                }
            } else {
                score -= 4.0;
            }
        } else {
            int reactantBondType = StereoFilter.convertBondOrder(queryBond);
            int productBondType = StereoFilter.convertBondOrder(targetBond);
            int rStereo = StereoFilter.convertBondStereo(queryBond);
            int pStereo = StereoFilter.convertBondStereo(targetBond);
            if (queryBond.getFlag(32) == targetBond.getFlag(32) && reactantBondType == productBondType) {
                score += 8.0;
            } else if (queryBond.getFlag(32) && targetBond.getFlag(32)) {
                score += 4.0;
            }
            score = reactantBondType == productBondType ? (score += (double)productBondType) : (score -= (double)(4 * Math.abs(reactantBondType - productBondType)));
            if (rStereo != 4 || pStereo != 4 || rStereo != 3 || pStereo != 3) {
                score = rStereo == pStereo ? (score += 1.0) : (score -= 1.0);
            }
        }
        return score;
    }

    public static synchronized int convertBondStereo(IBond bond) {
        int value;
        switch (bond.getStereo()) {
            case UP: {
                value = 1;
                break;
            }
            case UP_INVERTED: {
                value = 1;
                break;
            }
            case DOWN: {
                value = 6;
                break;
            }
            case DOWN_INVERTED: {
                value = 6;
                break;
            }
            case UP_OR_DOWN: {
                value = 4;
                break;
            }
            case UP_OR_DOWN_INVERTED: {
                value = 4;
                break;
            }
            case E_OR_Z: {
                value = 3;
                break;
            }
            default: {
                value = 0;
            }
        }
        return value;
    }

    public static synchronized int convertBondOrder(IBond bond) {
        int value;
        switch (bond.getOrder()) {
            case QUADRUPLE: {
                value = 4;
                break;
            }
            case TRIPLE: {
                value = 3;
                break;
            }
            case DOUBLE: {
                value = 2;
                break;
            }
            case SINGLE: {
                value = 1;
                break;
            }
            default: {
                value = 1;
            }
        }
        return value;
    }

    private synchronized double getRingMatchScore(List<IAtomContainer> list) throws CloneNotSupportedException {
        double lScore = 0.0;
        IAtomContainer listMap = list.get(0).clone();
        IAtomContainer subGraph = list.get(1).clone();
        try {
            Cycles cycles = Cycles.all(subGraph);
            lScore = this.getRingMatch(cycles.toRingSet(), listMap);
        }
        catch (Intractable ex) {
            Logger.getLogger(StereoFilter.class.getName()).log(Level.SEVERE, null, ex);
        }
        return lScore;
    }

    private synchronized double getRingMatch(IRingSet rings, IAtomContainer atoms) {
        double score = 0.0;
        for (IAtom a : atoms.atoms()) {
            for (IAtomContainer ring : rings.atomContainers()) {
                if (ring.contains(a)) {
                    score += 10.0;
                    continue;
                }
                score -= 10.0;
            }
        }
        return score;
    }

    private synchronized List<IAtomContainer> getMappedFragment(IAtomContainer molecule, Collection<IAtom> atomsMCS) throws CloneNotSupportedException {
        if (!(molecule instanceof IAtomContainer)) {
            return new ArrayList<IAtomContainer>(2);
        }
        IAtomContainer subgraphContainer = molecule.getBuilder().newInstance(IAtomContainer.class, molecule);
        ArrayList<IAtom> list = new ArrayList<IAtom>(atomsMCS.size());
        for (IAtom iAtom : atomsMCS) {
            int post = molecule.getAtomNumber(iAtom);
            list.add(subgraphContainer.getAtom(post));
        }
        AtomContainer rlist = new AtomContainer();
        for (IAtom atoms : subgraphContainer.atoms()) {
            if (list.contains(atoms)) continue;
            rlist.addAtom(atoms);
        }
        for (IAtom atoms : rlist.atoms()) {
            subgraphContainer.removeAtomAndConnectedElectronContainers(atoms);
        }
        ArrayList<IAtomContainer> arrayList = new ArrayList<IAtomContainer>(2);
        arrayList.add(rlist);
        arrayList.add(subgraphContainer);
        return arrayList;
    }
}

