/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.filters.ChemicalFilters;
import org.openscience.smsd.filters.IChemicalFilter;
import org.openscience.smsd.filters.Sotter;
import org.openscience.smsd.tools.BondEnergies;

public final class EnergyFilter
extends Sotter
implements IChemicalFilter<Double> {
    public static final Double MAX_ENERGY = Double.MAX_VALUE;
    private final List<Double> bEnergies;
    private final ChemicalFilters chemfilter;

    EnergyFilter(ChemicalFilters chemfilter) {
        this.chemfilter = chemfilter;
        this.bEnergies = Collections.synchronizedList(new ArrayList());
    }

    @Override
    public synchronized Double sortResults(Map<Integer, AtomAtomMapping> allAtomEnergyMCS, Map<Integer, Double> energySelectionMap) throws CDKException {
        double lowestEnergyScore;
        block1: {
            for (Integer Key2 : allAtomEnergyMCS.keySet()) {
                AtomAtomMapping mcsAtom = allAtomEnergyMCS.get(Key2);
                Double energies = this.getMappedMoleculeEnergies(mcsAtom);
                energySelectionMap.put(Key2, energies);
            }
            energySelectionMap = EnergyFilter.sortMapByValueInAscendingOrder(energySelectionMap);
            lowestEnergyScore = MAX_ENERGY;
            Iterator<Integer> iterator = energySelectionMap.keySet().iterator();
            if (!iterator.hasNext()) break block1;
            Integer key = iterator.next();
            lowestEnergyScore = energySelectionMap.get(key);
        }
        return lowestEnergyScore;
    }

    @Override
    public synchronized List<Double> getScores() {
        return Collections.unmodifiableList(this.bEnergies);
    }

    @Override
    public synchronized void clearScores() {
        this.bEnergies.clear();
    }

    @Override
    public synchronized void addScore(int counter, Double value) {
        this.bEnergies.add(counter, value);
    }

    @Override
    public synchronized void fillMap(Map<Integer, Double> energySelectionMap) {
        int Index2 = 0;
        for (Double score : this.bEnergies) {
            energySelectionMap.put(Index2, score);
            ++Index2;
        }
    }

    private synchronized Double getMappedMoleculeEnergies(AtomAtomMapping mcsAtomSolution) throws CDKException {
        int i;
        int i2;
        double totalBondEnergy = -9999.0;
        IAtomContainer educt = DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, this.chemfilter.getQuery());
        IAtomContainer product = DefaultChemObjectBuilder.getInstance().newInstance(IAtomContainer.class, this.chemfilter.getTarget());
        for (i2 = 0; i2 < educt.getAtomCount(); ++i2) {
            educt.getAtom(i2).setFlag(999, false);
        }
        for (i2 = 0; i2 < product.getAtomCount(); ++i2) {
            product.getAtom(i2).setFlag(999, false);
        }
        if (mcsAtomSolution != null) {
            Map<IAtom, IAtom> mappingsByAtoms = mcsAtomSolution.getMappingsByAtoms();
            mappingsByAtoms.entrySet().stream().map(mapping -> {
                ((IAtom)mapping.getKey()).setFlag(999, true);
                return mapping;
            }).forEach(mapping -> ((IAtom)mapping.getValue()).setFlag(999, true));
            totalBondEnergy = EnergyFilter.getEnergy(educt, product);
        }
        for (i = 0; i < educt.getAtomCount(); ++i) {
            educt.getAtom(i).setFlag(999, false);
        }
        for (i = 0; i < product.getAtomCount(); ++i) {
            product.getAtom(i).setFlag(999, false);
        }
        return totalBondEnergy;
    }

    private static synchronized double getEnergy(IAtomContainer educt, IAtomContainer product) throws CDKException {
        Double eEnergy = 0.0;
        BondEnergies bondEnergy = BondEnergies.getInstance();
        for (int i = 0; i < educt.getBondCount(); ++i) {
            IBond bond = educt.getBond(i);
            eEnergy = eEnergy + EnergyFilter.getBondEnergy(bond, bondEnergy);
        }
        Double pEnergy = 0.0;
        for (int j = 0; j < product.getBondCount(); ++j) {
            IBond bond = product.getBond(j);
            pEnergy = pEnergy + EnergyFilter.getBondEnergy(bond, bondEnergy);
        }
        return eEnergy + pEnergy;
    }

    private static synchronized double getBondEnergy(IBond bond, BondEnergies bondEnergy) {
        double energy = 0.0;
        if (bond.getAtom(0).getFlag(999) && !bond.getAtom(1).getFlag(999) || !bond.getAtom(0).getFlag(999) && bond.getAtom(1).getFlag(999)) {
            int val = bondEnergy.getEnergies(bond.getAtom(0), bond.getAtom(1), bond.getOrder());
            energy = val;
        }
        return energy;
    }
}

