/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib.vf2.mcs;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.smsd.algorithm.vflib.vf2.AtomMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.BondMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.DefaultAtomMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.DefaultBondMatcher;
import org.openscience.smsd.algorithm.vflib.vf2.mcs.StateStream;
import org.openscience.smsd.algorithm.vflib.vf2.mcs.VFSeedState;
import org.openscience.smsd.algorithm.vflib.vf2.sub.Pattern;

public final class VFSeed
extends Pattern {
    private final IAtomContainer query;
    private final int[][] g1;
    private final GraphUtil.EdgeToBondMap bonds1;
    private final AtomMatcher atomMatcher;
    private final BondMatcher bondMatcher;

    private VFSeed(IAtomContainer query2, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        this.query = query2;
        this.atomMatcher = new DefaultAtomMatcher(shouldMatchRings, matchAtomType);
        this.bondMatcher = new DefaultBondMatcher(shouldMatchBonds, shouldMatchRings, matchAtomType);
        this.bonds1 = GraphUtil.EdgeToBondMap.withSpaceFor(query2);
        this.g1 = GraphUtil.toAdjList(query2, this.bonds1);
    }

    @Override
    public List<Map<IAtom, IAtom>> matchAll(IAtomContainer target) {
        GraphUtil.EdgeToBondMap bonds2 = GraphUtil.EdgeToBondMap.withSpaceFor(target);
        int[][] g2 = GraphUtil.toAdjList(target, bonds2);
        VFIterable iterable = new VFIterable(this.query, target, this.g1, g2, this.bonds1, bonds2, this.atomMatcher, this.bondMatcher);
        ArrayList<Map<IAtom, IAtom>> mappings = new ArrayList<Map<IAtom, IAtom>>();
        for (Collection maps : iterable) {
            maps.stream().map(map -> {
                HashMap<IAtom, IAtom> atomAtomMapping = new HashMap<IAtom, IAtom>();
                for (int i = 0; i < ((int[])map).length; ++i) {
                    if (map[i] < 0) continue;
                    atomAtomMapping.put(this.query.getAtom(i), target.getAtom(map[i]));
                }
                return atomAtomMapping;
            }).forEach(atomAtomMapping -> mappings.add((Map<IAtom, IAtom>)atomAtomMapping));
        }
        return mappings;
    }

    public static Pattern findSeeds(IQueryAtomContainer query2) {
        boolean isQuery = query2 instanceof IQueryAtomContainer;
        return VFSeed.findSeeds(query2, false, false, false);
    }

    public static Pattern findSeeds(IAtomContainer query2, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        return new VFSeed(query2, shouldMatchBonds, shouldMatchRings, matchAtomType);
    }

    private static final class VFIterable
    implements Iterable<Collection<int[]>> {
        private final IAtomContainer container1;
        private final IAtomContainer container2;
        private final int[][] g1;
        private final int[][] g2;
        private final GraphUtil.EdgeToBondMap bonds1;
        private final GraphUtil.EdgeToBondMap bonds2;
        private final AtomMatcher atomMatcher;
        private final BondMatcher bondMatcher;

        private VFIterable(IAtomContainer container1, IAtomContainer container2, int[][] g1, int[][] g2, GraphUtil.EdgeToBondMap bonds1, GraphUtil.EdgeToBondMap bonds2, AtomMatcher atomMatcher, BondMatcher bondMatcher) {
            this.container1 = container1;
            this.container2 = container2;
            this.g1 = g1;
            this.g2 = g2;
            this.bonds1 = bonds1;
            this.bonds2 = bonds2;
            this.atomMatcher = atomMatcher;
            this.bondMatcher = bondMatcher;
        }

        @Override
        public Iterator<Collection<int[]>> iterator() {
            return new StateStream(new VFSeedState(this.container1, this.container2, this.g1, this.g2, this.bonds1, this.bonds2, this.atomMatcher, this.bondMatcher));
        }
    }
}

