/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.mcgregor.McGregor;
import org.openscience.smsd.algorithm.vflib.vf2.sub.Pattern;
import org.openscience.smsd.algorithm.vflib.vf2.sub.VF;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.interfaces.IResults;

public class VF2Sub
implements IResults {
    private final List<AtomAtomMapping> allAtomMCS;
    private final List<AtomAtomMapping> allAtomMCSCopy;
    private final List<Map<Integer, Integer>> allMCS;
    private final List<Map<Integer, Integer>> allMCSCopy;
    private List<Map<IAtom, IAtom>> vfLibSolutions;
    private final IAtomContainer source;
    private final IAtomContainer target;
    private final boolean shouldMatchRings;
    private final boolean matchBonds;
    private boolean matchAtomType;
    private int bestHitSize = -1;
    private int countR = 0;
    private int countP = 0;
    private boolean isSubgraph = false;
    private static final ILoggingTool Logger = LoggingToolFactory.createLoggingTool(VF2Sub.class);

    public VF2Sub(IAtomContainer source, IAtomContainer target, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        this.source = source;
        this.target = target;
        this.allAtomMCS = new ArrayList<AtomAtomMapping>();
        this.allAtomMCSCopy = new ArrayList<AtomAtomMapping>();
        this.allMCS = new ArrayList<Map<Integer, Integer>>();
        this.allMCSCopy = new ArrayList<Map<Integer, Integer>>();
        this.shouldMatchRings = shouldMatchRings;
        this.matchBonds = shouldMatchBonds;
        this.matchAtomType = matchAtomType;
        this.isSubgraph = this.findSubgraph();
    }

    public VF2Sub(IQueryAtomContainer source, IAtomContainer target) {
        this.source = source;
        this.target = target;
        this.allAtomMCS = new ArrayList<AtomAtomMapping>();
        this.allAtomMCSCopy = new ArrayList<AtomAtomMapping>();
        this.allMCS = new ArrayList<Map<Integer, Integer>>();
        this.allMCSCopy = new ArrayList<Map<Integer, Integer>>();
        this.shouldMatchRings = true;
        this.matchBonds = true;
        this.isSubgraph = this.findSubgraph();
    }

    private boolean findSubgraph() {
        if (!MoleculeInitializer.testIsSubgraphHeuristics(this.source, this.target, this.matchBonds)) {
            return false;
        }
        boolean timoutVF = this.searchVFMappings();
        boolean flag = this.isExtensionFeasible();
        if (flag && !this.vfLibSolutions.isEmpty() && !timoutVF && !(this.source instanceof IQueryAtomContainer)) {
            try {
                this.searchMcGregorMapping();
            }
            catch (IOException | CDKException ex) {
                Logger.error(Level.SEVERE, null, ex);
            }
        } else if (!this.allAtomMCSCopy.isEmpty() && this.allAtomMCSCopy.iterator().next().getCount() == this.source.getAtomCount()) {
            this.allAtomMCS.addAll(this.allAtomMCSCopy);
            this.allMCS.addAll(this.allMCSCopy);
        }
        return !this.allAtomMCS.isEmpty() && this.allAtomMCS.iterator().next().getCount() == this.source.getAtomCount();
    }

    private synchronized boolean isExtensionFeasible() {
        int commonAtomCount = this.checkCommonAtomCount(this.getReactantMol(), this.getProductMol());
        return commonAtomCount > this.bestHitSize;
    }

    private boolean hasMap(Map<Integer, Integer> maps, List<Map<Integer, Integer>> mapGlobal) {
        for (Map<Integer, Integer> test : mapGlobal) {
            if (!test.equals(maps)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(this.allAtomMCS);
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        if (this.allAtomMCS.iterator().hasNext()) {
            return this.allAtomMCS.iterator().next();
        }
        return new AtomAtomMapping(this.source, this.target);
    }

    private synchronized int checkCommonAtomCount(IAtomContainer reactantMolecule, IAtomContainer productMolecule) {
        ArrayList<String> atoms = new ArrayList<String>();
        for (int i = 0; i < reactantMolecule.getAtomCount(); ++i) {
            atoms.add(reactantMolecule.getAtom(i).getSymbol());
        }
        int common = 0;
        for (int i = 0; i < productMolecule.getAtomCount(); ++i) {
            String symbol = productMolecule.getAtom(i).getSymbol();
            if (!atoms.contains(symbol)) continue;
            atoms.remove(symbol);
            ++common;
        }
        return common;
    }

    private synchronized boolean searchVFMappings() {
        Object mapper = null;
        if (!(this.source instanceof IQueryAtomContainer) && !(this.target instanceof IQueryAtomContainer)) {
            this.countR = this.getReactantMol().getAtomCount();
            this.countP = this.getProductMol().getAtomCount();
        }
        this.vfLibSolutions = new ArrayList<Map<IAtom, IAtom>>();
        if (this.source instanceof IQueryAtomContainer) {
            Pattern findSubstructure = VF.findSubstructure((IQueryAtomContainer)this.source);
            List<Map<IAtom, IAtom>> maps = findSubstructure.matchAll(this.getProductMol());
            if (maps != null) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(true);
        } else if (this.countR <= this.countP) {
            Pattern findSubstructure = VF.findSubstructure(this.source, this.matchBonds, this.shouldMatchRings, this.matchAtomType);
            List<Map<IAtom, IAtom>> maps = findSubstructure.matchAll(this.getProductMol());
            if (maps != null) {
                this.vfLibSolutions.addAll(maps);
            }
            this.setVFMappings(true);
        }
        return mapper != null;
    }

    private synchronized void searchMcGregorMapping() throws CDKException, IOException {
        List<List<Integer>> mappings = new ArrayList<List<Integer>>();
        boolean ROPFlag = true;
        for (Map<Integer, Integer> firstPassMappings : this.allMCSCopy) {
            McGregor mgit;
            TreeMap<Integer, Integer> extendMapping = new TreeMap<Integer, Integer>(firstPassMappings);
            if (this.source instanceof IQueryAtomContainer) {
                mgit = new McGregor((IQueryAtomContainer)this.source, this.target, mappings, this.matchBonds, this.shouldMatchRings, this.matchAtomType);
                mgit.startMcGregorIteration((IQueryAtomContainer)this.source, mgit.getMCSSize(), extendMapping);
            } else {
                extendMapping.clear();
                mgit = new McGregor(this.target, this.source, mappings, this.matchBonds, this.shouldMatchRings, this.matchAtomType);
                ROPFlag = false;
                for (Map.Entry<Integer, Integer> map : firstPassMappings.entrySet()) {
                    extendMapping.put(map.getValue(), map.getKey());
                }
                mgit.startMcGregorIteration(this.target, mgit.getMCSSize(), extendMapping);
            }
            mappings = mgit.getMappings();
        }
        this.setMcGregorMappings(ROPFlag, mappings);
    }

    private synchronized void setVFMappings(boolean RONP) {
        int counter = 0;
        for (Map<IAtom, IAtom> solution : this.vfLibSolutions) {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
            for (Map.Entry<IAtom, IAtom> mapping : solution.entrySet()) {
                Integer tIndex;
                Integer qIndex;
                IAtom tAtom;
                IAtom qAtom;
                if (RONP) {
                    qAtom = mapping.getKey();
                    tAtom = mapping.getValue();
                    qIndex = this.source.getAtomNumber(qAtom);
                    tIndex = this.target.getAtomNumber(tAtom);
                } else {
                    tAtom = mapping.getKey();
                    qAtom = mapping.getValue();
                    qIndex = this.source.getAtomNumber(qAtom);
                    tIndex = this.target.getAtomNumber(tAtom);
                }
                if (qIndex != -1 && tIndex != -1) {
                    atomatomMapping.put(qAtom, tAtom);
                    indexindexMapping.put(qIndex, tIndex);
                    continue;
                }
                try {
                    throw new CDKException("Atom index pointing to -1");
                }
                catch (CDKException ex) {
                    Logger.error(Level.SEVERE, null, ex);
                }
            }
            if (indexindexMapping.size() > this.bestHitSize) {
                this.bestHitSize = indexindexMapping.size();
                this.allAtomMCSCopy.clear();
                this.allMCSCopy.clear();
                counter = 0;
            }
            if (atomatomMapping.isEmpty() || this.hasMap(indexindexMapping, this.allMCSCopy) || indexindexMapping.size() != this.bestHitSize) continue;
            this.allAtomMCSCopy.add(counter, atomatomMapping);
            this.allMCSCopy.add(counter, indexindexMapping);
            ++counter;
        }
    }

    private synchronized void setMcGregorMappings(boolean RONP, List<List<Integer>> mappings) throws CDKException {
        int counter = 0;
        for (List<Integer> mapping : mappings) {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            TreeMap<Integer, Integer> indexindexMapping = new TreeMap<Integer, Integer>();
            for (int index = 0; index < mapping.size(); index += 2) {
                Integer tIndex;
                Integer qIndex;
                IAtom tAtom;
                IAtom qAtom;
                if (RONP) {
                    qAtom = this.getReactantMol().getAtom(mapping.get(index));
                    tAtom = this.getProductMol().getAtom(mapping.get(index + 1));
                    qIndex = mapping.get(index);
                    tIndex = mapping.get(index + 1);
                } else {
                    qAtom = this.getReactantMol().getAtom(mapping.get(index + 1));
                    tAtom = this.getProductMol().getAtom(mapping.get(index));
                    qIndex = mapping.get(index + 1);
                    tIndex = mapping.get(index);
                }
                if (qIndex == null || tIndex == null) {
                    throw new CDKException("Atom index pointing to NULL");
                }
                atomatomMapping.put(qAtom, tAtom);
                indexindexMapping.put(qIndex, tIndex);
            }
            if (indexindexMapping.size() > this.bestHitSize) {
                this.bestHitSize = indexindexMapping.size();
                this.allAtomMCS.clear();
                this.allMCS.clear();
                counter = 0;
            }
            if (atomatomMapping.isEmpty() || this.hasMap(indexindexMapping, this.allMCS) || indexindexMapping.size() != this.bestHitSize) continue;
            this.allAtomMCS.add(counter, atomatomMapping);
            this.allMCS.add(counter, indexindexMapping);
            ++counter;
        }
    }

    private synchronized IAtomContainer getReactantMol() {
        return this.source;
    }

    private synchronized IAtomContainer getProductMol() {
        return this.target;
    }

    public boolean isSubgraph() {
        return this.isSubgraph;
    }
}

