/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.vflib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.algorithm.mcsplus.BKKCKCF;
import org.openscience.smsd.algorithm.mcsplus.GenerateCompatibilityGraph;
import org.openscience.smsd.algorithm.rgraph.CDKRMapHandler;
import org.openscience.smsd.algorithm.vflib.Map1ValueComparator;
import org.openscience.smsd.algorithm.vflib.SortOrder;
import org.openscience.smsd.interfaces.Algorithm;

public class MCSSeedGenerator
implements Callable<List<AtomAtomMapping>> {
    private final IAtomContainer source;
    private final IAtomContainer target;
    private final List<AtomAtomMapping> allCliqueAtomMCS;
    private final boolean ringMatch;
    private final Algorithm algorithm;
    private static final ILoggingTool Logger = LoggingToolFactory.createLoggingTool(MCSSeedGenerator.class);
    private final boolean bondMatch;
    private final boolean matchAtomType;

    public MCSSeedGenerator(IAtomContainer source, IAtomContainer target, boolean bondMatch, boolean ringMatch, boolean matchAtomType, Algorithm algorithm) {
        this.source = source;
        this.target = target;
        this.allCliqueAtomMCS = new ArrayList<AtomAtomMapping>();
        this.ringMatch = ringMatch;
        this.algorithm = algorithm;
        this.matchAtomType = matchAtomType;
        this.bondMatch = bondMatch;
    }

    public MCSSeedGenerator(IQueryAtomContainer source, IAtomContainer target, Algorithm algorithm) {
        this.source = source;
        this.target = target;
        this.allCliqueAtomMCS = new ArrayList<AtomAtomMapping>();
        this.ringMatch = true;
        this.algorithm = algorithm;
        this.matchAtomType = true;
        this.bondMatch = true;
    }

    @Override
    public List<AtomAtomMapping> call() throws Exception {
        switch (this.algorithm) {
            case CDKMCS: {
                List<AtomAtomMapping> addUIT = this.addUIT();
                return addUIT;
            }
            case MCSPlus: {
                List<AtomAtomMapping> addKochCliques = this.addKochCliques();
                return addKochCliques;
            }
        }
        return Collections.unmodifiableList(this.allCliqueAtomMCS);
    }

    protected synchronized List<AtomAtomMapping> addKochCliques() throws IOException {
        IAtomContainer ac2;
        IAtomContainer ac1;
        boolean flagExchange = false;
        if (this.source instanceof IQueryAtomContainer) {
            ac1 = (IQueryAtomContainer)this.source;
            ac2 = this.target;
        } else if (this.source.getAtomCount() < this.target.getAtomCount()) {
            ac1 = this.source;
            ac2 = this.target;
        } else {
            flagExchange = true;
            ac1 = this.target;
            ac2 = this.source;
        }
        GenerateCompatibilityGraph gcg = new GenerateCompatibilityGraph(ac1, ac2, this.bondMatch, this.ringMatch, this.matchAtomType);
        List<Integer> comp_graph_nodes = gcg.getCompGraphNodes();
        List<Integer> cEdges = gcg.getCEgdes();
        List<Integer> dEdges = gcg.getDEgdes();
        BKKCKCF init = new BKKCKCF(comp_graph_nodes, cEdges, dEdges);
        Stack<List<Integer>> maxCliqueSet = new Stack<List<Integer>>();
        maxCliqueSet.addAll(init.getMaxCliqueSet());
        Collections.sort(maxCliqueSet, (a1, a2) -> a2.size() - a1.size());
        while (!maxCliqueSet.empty()) {
            List peek = (List)maxCliqueSet.peek();
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            for (Integer value : peek) {
                int[] index = this.getIndex(value, comp_graph_nodes);
                Integer qIndex = index[0];
                Integer tIndex = index[1];
                if (qIndex != -1 && tIndex != -1) {
                    IAtom tAtom;
                    IAtom qAtom;
                    if (flagExchange) {
                        qAtom = this.source.getAtom(tIndex);
                        tAtom = this.target.getAtom(qIndex);
                    } else {
                        qAtom = this.source.getAtom(qIndex);
                        tAtom = this.target.getAtom(tIndex);
                    }
                    atomatomMapping.put(qAtom, tAtom);
                    continue;
                }
                try {
                    throw new CDKException("Atom index pointing to -1");
                }
                catch (CDKException ex) {
                    Logger.error(Level.SEVERE, null, ex);
                }
            }
            if (!atomatomMapping.isEmpty()) {
                this.allCliqueAtomMCS.add(atomatomMapping);
            }
            maxCliqueSet.pop();
        }
        gcg.clear();
        return Collections.unmodifiableList(this.allCliqueAtomMCS);
    }

    private List<AtomAtomMapping> addUIT() throws CDKException {
        List<Map<Integer, Integer>> solutions;
        boolean rOnPFlag;
        CDKRMapHandler rmap = new CDKRMapHandler();
        if (this.source instanceof IQueryAtomContainer) {
            rOnPFlag = false;
            solutions = rmap.calculateOverlapsAndReduce(this.target, (IQueryAtomContainer)this.source);
        } else if (this.source.getAtomCount() > this.target.getAtomCount()) {
            rOnPFlag = true;
            solutions = rmap.calculateOverlapsAndReduce(this.source, this.target, this.bondMatch, this.ringMatch, this.matchAtomType);
        } else {
            rOnPFlag = false;
            solutions = rmap.calculateOverlapsAndReduce(this.target, this.source, this.bondMatch, this.ringMatch, this.matchAtomType);
        }
        return this.setUITMappings(rOnPFlag, solutions);
    }

    private List<AtomAtomMapping> setUITMappings(boolean RONP, List<Map<Integer, Integer>> sol) {
        Collections.sort(sol, new Map1ValueComparator(SortOrder.DESCENDING));
        sol.stream().map(solution -> {
            AtomAtomMapping atomatomMapping = new AtomAtomMapping(this.source, this.target);
            solution.keySet().stream().forEach(qAtomIndex -> {
                IAtom tAtom;
                IAtom qAtom;
                if (RONP) {
                    qAtom = this.source.getAtom((int)qAtomIndex);
                    tAtom = this.target.getAtom((Integer)solution.get(qAtomIndex));
                } else {
                    tAtom = this.target.getAtom((int)qAtomIndex);
                    qAtom = this.source.getAtom((Integer)solution.get(qAtomIndex));
                }
                int qIndex = this.source.getAtomNumber(qAtom);
                int tIndex = this.target.getAtomNumber(tAtom);
                if (qIndex != -1 && tIndex != -1) {
                    atomatomMapping.put(qAtom, tAtom);
                } else {
                    try {
                        throw new CDKException("Atom index pointing to -1");
                    }
                    catch (CDKException ex) {
                        Logger.error(Level.SEVERE, null, ex);
                    }
                }
            });
            return atomatomMapping;
        }).filter(atomatomMapping -> !atomatomMapping.isEmpty()).forEach(atomatomMapping -> this.allCliqueAtomMCS.add((AtomAtomMapping)atomatomMapping));
        return Collections.unmodifiableList(this.allCliqueAtomMCS);
    }

    private int[] getIndex(int cliqueIndex, List<Integer> comp_graph_nodes) {
        int[] v = new int[]{-1, -1};
        for (int i = 0; i < comp_graph_nodes.size(); i += 3) {
            if (cliqueIndex != comp_graph_nodes.get(i + 2)) continue;
            v[0] = comp_graph_nodes.get(i);
            v[1] = comp_graph_nodes.get(i + 1);
        }
        return v;
    }
}

