/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd.algorithm.mcgregor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryBond;
import org.openscience.smsd.algorithm.matchers.DefaultMatcher;
import org.openscience.smsd.algorithm.mcgregor.McgregorHelper;
import org.openscience.smsd.helper.BinaryTree;

public class McGregorChecks {
    protected static boolean isFurtherMappingPossible(IAtomContainer source, IAtomContainer target, int neighborBondNumA, int neighborBondNumB, List<Integer> i_bond_neighbor_atoms_A, List<Integer> i_bond_neighbor_atoms_B, List<String> cBondNeighborsA, List<String> cBondNeighborsB, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        for (int row = 0; row < neighborBondNumA; ++row) {
            String G1A = cBondNeighborsA.get(row * 4 + 0);
            String G2A = cBondNeighborsA.get(row * 4 + 1);
            for (int column = 0; column < neighborBondNumB; ++column) {
                IBond productBond;
                IAtom P2_B;
                IAtom P1_B;
                IBond reactantBond;
                IAtom R2_A;
                IAtom R1_A;
                int Index_JPlus1;
                int Index_J;
                int Index_IPlus1;
                String G1B = cBondNeighborsB.get(column * 4 + 0);
                String G2B = cBondNeighborsB.get(column * 4 + 1);
                if (!(source instanceof IQueryAtomContainer) && McGregorChecks.isAtomMatch(G1A, G2A, G1B, G2B)) {
                    try {
                        int Index_I = i_bond_neighbor_atoms_A.get(row * 3 + 0);
                        Index_IPlus1 = i_bond_neighbor_atoms_A.get(row * 3 + 1);
                        Index_J = i_bond_neighbor_atoms_B.get(column * 3 + 0);
                        Index_JPlus1 = i_bond_neighbor_atoms_B.get(column * 3 + 1);
                        R1_A = source.getAtom(Index_I);
                        R2_A = source.getAtom(Index_IPlus1);
                        reactantBond = source.getBond(R1_A, R2_A);
                        P1_B = target.getAtom(Index_J);
                        P2_B = target.getAtom(Index_JPlus1);
                        productBond = target.getBond(P1_B, P2_B);
                        if (McGregorChecks.isMatchFeasible(reactantBond, productBond, shouldMatchBonds, shouldMatchRings, matchAtomType)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (!(source instanceof IQueryAtomContainer)) continue;
                try {
                    int Index_I = i_bond_neighbor_atoms_A.get(row * 3 + 0);
                    Index_IPlus1 = i_bond_neighbor_atoms_A.get(row * 3 + 1);
                    Index_J = i_bond_neighbor_atoms_B.get(column * 3 + 0);
                    Index_JPlus1 = i_bond_neighbor_atoms_B.get(column * 3 + 1);
                    R1_A = source.getAtom(Index_I);
                    R2_A = source.getAtom(Index_IPlus1);
                    reactantBond = source.getBond(R1_A, R2_A);
                    P1_B = target.getAtom(Index_J);
                    P2_B = target.getAtom(Index_JPlus1);
                    productBond = target.getBond(P1_B, P2_B);
                    if (!McGregorChecks.isMatchFeasible(reactantBond, productBond, shouldMatchBonds, shouldMatchRings, matchAtomType)) continue;
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    protected static boolean isMatchFeasible(IBond bondA1, IBond bondA2, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        if (bondA1 instanceof IQueryBond) {
            if (((IQueryBond)bondA1).matches(bondA2)) {
                IQueryAtom atom1 = (IQueryAtom)bondA1.getAtom(0);
                IQueryAtom atom2 = (IQueryAtom)bondA1.getAtom(1);
                return atom1.matches(bondA2.getAtom(0)) && atom2.matches(bondA2.getAtom(1)) || atom1.matches(bondA2.getAtom(1)) && atom2.matches(bondA2.getAtom(0));
            }
            return false;
        }
        return DefaultMatcher.matches(bondA1, bondA2, shouldMatchBonds, shouldMatchRings, matchAtomType);
    }

    protected static int searchCorrespondingAtom(int mappedAtomsSize, int atomFromOtherMolecule, int molecule, List<Integer> mapped_atoms_org) {
        ArrayList<Integer> mapped_atoms = new ArrayList<Integer>(mapped_atoms_org);
        int corresponding_atom = 0;
        for (int a = 0; a < mappedAtomsSize; ++a) {
            if (molecule == 1 && (Integer)mapped_atoms.get(a * 2 + 0) == atomFromOtherMolecule) {
                corresponding_atom = (Integer)mapped_atoms.get(a * 2 + 1);
            }
            if (molecule != 2 || (Integer)mapped_atoms.get(a * 2 + 1) != atomFromOtherMolecule) continue;
            corresponding_atom = (Integer)mapped_atoms.get(a * 2 + 0);
        }
        return corresponding_atom;
    }

    protected static boolean isAtomMatch(String G1A, String G2A, String G1B, String G2B) {
        return G1A.compareToIgnoreCase(G1B) == 0 && G2A.compareToIgnoreCase(G2B) == 0 || G1A.compareToIgnoreCase(G2B) == 0 && G2A.compareToIgnoreCase(G1B) == 0;
    }

    protected static int removeTreeStructure(BinaryTree cur_struc) {
        BinaryTree equal_struc = cur_struc.getEqual();
        BinaryTree not_equal_struc = cur_struc.getNotEqual();
        cur_struc = null;
        if (equal_struc != null) {
            McGregorChecks.removeTreeStructure(equal_struc);
        }
        if (not_equal_struc != null) {
            McGregorChecks.removeTreeStructure(not_equal_struc);
        }
        return 0;
    }

    protected static List<Integer> removeRecurringMappings(List<Integer> atom_mapping) {
        boolean exist = true;
        ArrayList<Integer> temp_map = new ArrayList<Integer>();
        int temp_counter = 0;
        int atom_mapping_size = atom_mapping.size();
        for (int x = 0; x < atom_mapping_size; x += 2) {
            int atom = atom_mapping.get(x);
            for (int y = x + 2; y < atom_mapping_size; y += 2) {
                if (atom != atom_mapping.get(y)) continue;
                exist = false;
            }
            if (exist) {
                temp_map.add(atom_mapping.get(x + 0));
                temp_map.add(atom_mapping.get(x + 1));
                temp_counter += 2;
            }
            exist = true;
        }
        return temp_map;
    }

    protected static void removeRedundantArcs(int row, int column, List<Integer> MARCS, McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        List<Integer> iBondNeighborAtomsA = mcGregorHelper.getiBondNeighborAtomsA();
        List<Integer> iBondNeighborAtomsB = mcGregorHelper.getiBondNeighborAtomsB();
        int G1_atom = iBondNeighborAtomsA.get(row * 3 + 0);
        int G2_atom = iBondNeighborAtomsA.get(row * 3 + 1);
        int G3_atom = iBondNeighborAtomsB.get(column * 3 + 0);
        int G4_atom = iBondNeighborAtomsB.get(column * 3 + 1);
        for (int x = 0; x < neighborBondNumA; ++x) {
            int row_atom1 = iBondNeighborAtomsA.get(x * 3 + 0);
            int row_atom2 = iBondNeighborAtomsA.get(x * 3 + 1);
            for (int y = 0; y < neighborBondNumB; ++y) {
                int column_atom4;
                int column_atom3 = iBondNeighborAtomsB.get(y * 3 + 0);
                if (!McGregorChecks.cases(G1_atom, G2_atom, G3_atom, G4_atom, row_atom1, row_atom2, column_atom3, column_atom4 = iBondNeighborAtomsB.get(y * 3 + 1).intValue())) continue;
                MARCS.set(x * neighborBondNumB + y, 0);
            }
        }
        for (int v = 0; v < neighborBondNumA; ++v) {
            MARCS.set(v * neighborBondNumB + column, 0);
        }
        for (int w = 0; w < neighborBondNumB; ++w) {
            MARCS.set(row * neighborBondNumB + w, 0);
        }
        MARCS.set(row * neighborBondNumB + column, 1);
    }

    protected static List<String> generateCSetCopy(int bond_number, List<String> c_set) {
        ArrayList<String> cTabCopy = new ArrayList<String>();
        for (int a = 0; a < bond_number; ++a) {
            cTabCopy.add(c_set.get(a * 4 + 0));
            cTabCopy.add(c_set.get(a * 4 + 1));
            cTabCopy.add("X");
            cTabCopy.add("X");
        }
        return cTabCopy;
    }

    protected static List<String> generateCTabCopy(IAtomContainer atomContainer) throws IOException {
        ArrayList<String> c_tab_copy = new ArrayList<String>();
        for (int a = 0; a < atomContainer.getBondCount(); ++a) {
            String AtomI = atomContainer.getBond(a).getAtom(0).getSymbol();
            String AtomJ = atomContainer.getBond(a).getAtom(1).getSymbol();
            c_tab_copy.add(AtomI);
            c_tab_copy.add(AtomJ);
            c_tab_copy.add("X");
            c_tab_copy.add("X");
        }
        return c_tab_copy;
    }

    protected static boolean case1(int G1_atom, int G3_atom, int G4_atom, int row_atom1, int row_atom2, int column_atom3, int column_atom4) {
        return (G1_atom == row_atom1 || G1_atom == row_atom2) && column_atom3 != G3_atom && column_atom4 != G3_atom && column_atom3 != G4_atom && column_atom4 != G4_atom;
    }

    protected static boolean case2(int G2_atom, int G3_atom, int G4_atom, int row_atom1, int row_atom2, int column_atom3, int column_atom4) {
        return (G2_atom == row_atom1 || G2_atom == row_atom2) && column_atom3 != G3_atom && column_atom4 != G3_atom && column_atom3 != G4_atom && column_atom4 != G4_atom;
    }

    protected static boolean case3(int G1_atom, int G3_atom, int G2_atom, int row_atom1, int row_atom2, int column_atom3, int column_atom4) {
        return (G3_atom == column_atom3 || G3_atom == column_atom4) && row_atom1 != G1_atom && row_atom2 != G1_atom && row_atom1 != G2_atom && row_atom2 != G2_atom;
    }

    protected static boolean case4(int G1_atom, int G2_atom, int G4_atom, int row_atom1, int row_atom2, int column_atom3, int column_atom4) {
        return (G4_atom == column_atom3 || G4_atom == column_atom4) && row_atom1 != G1_atom && row_atom2 != G1_atom && row_atom1 != G2_atom && row_atom2 != G2_atom;
    }

    protected static boolean cases(int G1_atom, int G2_atom, int G3_atom, int G4_atom, int row_atom1, int row_atom2, int column_atom3, int column_atom4) {
        return McGregorChecks.case1(G1_atom, G3_atom, G4_atom, row_atom1, row_atom2, column_atom3, column_atom4) || McGregorChecks.case2(G2_atom, G3_atom, G4_atom, row_atom1, row_atom2, column_atom3, column_atom4) || McGregorChecks.case3(G1_atom, G3_atom, G2_atom, row_atom1, row_atom2, column_atom3, column_atom4) || McGregorChecks.case4(G1_atom, G2_atom, G4_atom, row_atom1, row_atom2, column_atom3, column_atom4);
    }

    protected static List<Integer> setArcs(IAtomContainer source, IAtomContainer target, int neighborBondNumA, int neighborBondNumB, List<Integer> i_bond_neighbor_atoms_A, List<Integer> i_bond_neighbor_atoms_B, List<String> cBondNeighborsA, List<String> cBondNeighborsB, List<Integer> modifiedARCS, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        for (int row = 0; row < neighborBondNumA; ++row) {
            for (int column = 0; column < neighborBondNumB; ++column) {
                IAtom P2_B;
                String G2B;
                String G1B;
                String G2A;
                String G1A = cBondNeighborsA.get(row * 4 + 0);
                if (!McGregorChecks.isAtomMatch(G1A, G2A = cBondNeighborsA.get(row * 4 + 1), G1B = cBondNeighborsB.get(column * 4 + 0), G2B = cBondNeighborsB.get(column * 4 + 1))) continue;
                int Index_I = i_bond_neighbor_atoms_A.get(row * 3 + 0);
                int Index_IPlus1 = i_bond_neighbor_atoms_A.get(row * 3 + 1);
                IAtom R1_A = source.getAtom(Index_I);
                IAtom R2_A = source.getAtom(Index_IPlus1);
                IBond reactantBond = source.getBond(R1_A, R2_A);
                int Index_J = i_bond_neighbor_atoms_B.get(column * 3 + 0);
                int Index_JPlus1 = i_bond_neighbor_atoms_B.get(column * 3 + 1);
                IAtom P1_B = target.getAtom(Index_J);
                IBond productBond = target.getBond(P1_B, P2_B = target.getAtom(Index_JPlus1));
                if (!McGregorChecks.isMatchFeasible(reactantBond, productBond, shouldMatchBonds, shouldMatchRings, matchAtomType)) continue;
                modifiedARCS.set(row * neighborBondNumB + column, 1);
            }
        }
        return modifiedARCS;
    }

    protected static int countArcsLeft(List<Integer> TEMPMARCS, int neighborBondNumA, int neighborBondNumB) {
        int arcsleft = 0;
        for (int a = 0; a < neighborBondNumA; ++a) {
            for (int b = 0; b < neighborBondNumB; ++b) {
                if (TEMPMARCS.get(a * neighborBondNumB + b) != 1) continue;
                ++arcsleft;
            }
        }
        return arcsleft;
    }

    protected static int changeCharBonds(int corresponding_atom, String new_symbol, int neighbor_bondnum, IAtomContainer atomContainer, List<String> c_bond_neighbors) {
        for (int atomIndex = 0; atomIndex < neighbor_bondnum; ++atomIndex) {
            IBond bond = atomContainer.getBond(atomIndex);
            if (atomContainer.getAtomNumber(bond.getAtom(0)) == corresponding_atom && c_bond_neighbors.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                c_bond_neighbors.set(atomIndex * 4 + 2, c_bond_neighbors.get(atomIndex * 4 + 0));
                c_bond_neighbors.set(atomIndex * 4 + 0, new_symbol);
            }
            if (atomContainer.getAtomNumber(bond.getAtom(1)) != corresponding_atom || c_bond_neighbors.get(atomIndex * 4 + 3).compareToIgnoreCase("X") != 0) continue;
            c_bond_neighbors.set(atomIndex * 4 + 3, c_bond_neighbors.get(atomIndex * 4 + 1));
            c_bond_neighbors.set(atomIndex * 4 + 1, new_symbol);
        }
        return 0;
    }

    protected static int changeCharBonds(int corresponding_atom, String new_symbol, int neighbor_bondnum, List<Integer> i_bond_neighbors, List<String> c_bond_neighbors) {
        for (int atomIndex = 0; atomIndex < neighbor_bondnum; ++atomIndex) {
            if (i_bond_neighbors.get(atomIndex * 3 + 0) == corresponding_atom && c_bond_neighbors.get(atomIndex * 4 + 2).compareToIgnoreCase("X") == 0) {
                c_bond_neighbors.set(atomIndex * 4 + 2, c_bond_neighbors.get(atomIndex * 4 + 0));
                c_bond_neighbors.set(atomIndex * 4 + 0, new_symbol);
            }
            if (i_bond_neighbors.get(atomIndex * 3 + 1) != corresponding_atom || c_bond_neighbors.get(atomIndex * 4 + 3).compareToIgnoreCase("X") != 0) continue;
            c_bond_neighbors.set(atomIndex * 4 + 3, c_bond_neighbors.get(atomIndex * 4 + 1));
            c_bond_neighbors.set(atomIndex * 4 + 1, new_symbol);
        }
        return 0;
    }

    static boolean isFurtherMappingPossible(IAtomContainer source, IAtomContainer target, McgregorHelper mcGregorHelper, boolean shouldMatchBonds, boolean shouldMatchRings, boolean matchAtomType) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        List<Integer> iBondNeighborAtomsA = mcGregorHelper.getiBondNeighborAtomsA();
        List<Integer> iBondNeighborAtomsB = mcGregorHelper.getiBondNeighborAtomsB();
        List<String> cBondNeighborsA = mcGregorHelper.getcBondNeighborsA();
        List<String> cBondNeighborsB = mcGregorHelper.getcBondNeighborsB();
        for (int row = 0; row < neighborBondNumA; ++row) {
            String G1A = cBondNeighborsA.get(row * 4 + 0);
            String G2A = cBondNeighborsA.get(row * 4 + 1);
            for (int column = 0; column < neighborBondNumB; ++column) {
                IBond productBond;
                IAtom p2_B;
                IAtom p1_B;
                IBond reactantBond;
                IAtom r2_A;
                IAtom r1_A;
                int Index_JPlus1;
                int Index_J;
                int Index_IPlus1;
                String G1B = cBondNeighborsB.get(column * 4 + 0);
                String G2B = cBondNeighborsB.get(column * 4 + 1);
                if (source instanceof IQueryAtomContainer) {
                    try {
                        int Index_I = iBondNeighborAtomsA.get(row * 3 + 0);
                        Index_IPlus1 = iBondNeighborAtomsA.get(row * 3 + 1);
                        Index_J = iBondNeighborAtomsB.get(column * 3 + 0);
                        Index_JPlus1 = iBondNeighborAtomsB.get(column * 3 + 1);
                        r1_A = source.getAtom(Index_I);
                        r2_A = source.getAtom(Index_IPlus1);
                        reactantBond = source.getBond(r1_A, r2_A);
                        p1_B = target.getAtom(Index_J);
                        p2_B = target.getAtom(Index_JPlus1);
                        productBond = target.getBond(p1_B, p2_B);
                        if (McGregorChecks.isMatchFeasible(reactantBond, productBond, shouldMatchBonds, shouldMatchRings, matchAtomType)) {
                            return true;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                if (source instanceof IQueryAtomContainer || !McGregorChecks.isAtomMatch(G1A, G2A, G1B, G2B)) continue;
                try {
                    int Index_I = iBondNeighborAtomsA.get(row * 3 + 0);
                    Index_IPlus1 = iBondNeighborAtomsA.get(row * 3 + 1);
                    Index_J = iBondNeighborAtomsB.get(column * 3 + 0);
                    Index_JPlus1 = iBondNeighborAtomsB.get(column * 3 + 1);
                    r1_A = source.getAtom(Index_I);
                    r2_A = source.getAtom(Index_IPlus1);
                    reactantBond = source.getBond(r1_A, r2_A);
                    p1_B = target.getAtom(Index_J);
                    p2_B = target.getAtom(Index_JPlus1);
                    productBond = target.getBond(p1_B, p2_B);
                    if (!McGregorChecks.isMatchFeasible(reactantBond, productBond, shouldMatchBonds, shouldMatchRings, matchAtomType)) continue;
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return false;
    }

    static List<Integer> markUnMappedAtoms(boolean flag, IAtomContainer container, Map<Integer, Integer> present_Mapping) {
        ArrayList<Integer> unmappedMolAtoms = new ArrayList<Integer>();
        int unmapped_num = 0;
        boolean atom_is_unmapped = true;
        for (int a = 0; a < container.getAtomCount(); ++a) {
            if (flag && present_Mapping.containsKey(a)) {
                atom_is_unmapped = false;
            } else if (!flag && present_Mapping.containsValue(a)) {
                atom_is_unmapped = false;
            }
            if (atom_is_unmapped) {
                unmappedMolAtoms.add(unmapped_num++, a);
            }
            atom_is_unmapped = true;
        }
        return unmappedMolAtoms;
    }

    static List<Integer> markUnMappedAtoms(boolean flag, IAtomContainer container, List<Integer> mapped_atoms, int clique_siz) {
        ArrayList<Integer> unmappedMolAtoms = new ArrayList<Integer>();
        int unmapped_num = 0;
        boolean atom_is_unmapped = true;
        for (int a = 0; a < container.getAtomCount(); ++a) {
            for (int b = 0; b < clique_siz; b += 2) {
                if (flag && mapped_atoms.get(b) == a) {
                    atom_is_unmapped = false;
                    continue;
                }
                if (flag || mapped_atoms.get(b + 1) != a) continue;
                atom_is_unmapped = false;
            }
            if (atom_is_unmapped) {
                unmappedMolAtoms.add(unmapped_num++, a);
            }
            atom_is_unmapped = true;
        }
        return unmappedMolAtoms;
    }
}

