/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd;

import java.io.Serializable;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.BaseMapping;
import org.openscience.smsd.Substructure;
import org.openscience.smsd.algorithm.mcsplus.MCSPlusHandler;
import org.openscience.smsd.algorithm.rgraph.CDKMCSHandler;
import org.openscience.smsd.algorithm.single.SingleMappingHandler;
import org.openscience.smsd.algorithm.vflib.VF2MCS;
import org.openscience.smsd.helper.MoleculeInitializer;
import org.openscience.smsd.interfaces.Algorithm;

public final class Isomorphism
extends BaseMapping
implements Serializable {
    private static final ILoggingTool logger = LoggingToolFactory.createLoggingTool(Isomorphism.class);
    static final long serialVersionUID = 10278639972837495L;
    private final Algorithm algorithmType;
    private double bondSensitiveMcGregorOut = -1.0;
    private double bondInSensitiveMcGregor = -1.0;

    public Isomorphism(IQueryAtomContainer query2, IAtomContainer target, Algorithm algorithmType) {
        super(query2, target);
        this.algorithmType = algorithmType;
        this.mcsBuilder(query2, target);
        super.setSubgraph(this.isSubgraph());
    }

    public Isomorphism(IAtomContainer query2, IAtomContainer target, Algorithm algorithmType, boolean bondTypeFlag, boolean matchRings, boolean matchAtomType) {
        super(query2, target, bondTypeFlag, matchRings, matchAtomType);
        this.algorithmType = algorithmType;
        if (super.isMatchRings()) {
            try {
                MoleculeInitializer.initializeMolecule(super.getQuery());
                MoleculeInitializer.initializeMolecule(super.getTarget());
            }
            catch (CDKException cDKException) {
                // empty catch block
            }
        }
        this.mcsBuilder(super.getQuery(), super.getTarget());
        super.setSubgraph(this.isSubgraph());
    }

    private synchronized void mcsBuilder(IAtomContainer mol1, IAtomContainer mol2) {
        int rBondCount = mol1.getBondCount();
        int pBondCount = mol2.getBondCount();
        int rAtomCount = mol1.getAtomCount();
        int pAtomCount = mol2.getAtomCount();
        if (rBondCount == 0 && rAtomCount > 0 || pBondCount == 0 && pAtomCount > 0) {
            this.singleMapping();
        } else {
            this.chooseAlgorithm();
        }
    }

    private synchronized void mcsBuilder(IQueryAtomContainer mol1, IAtomContainer mol2) {
        int rBondCount = mol1.getBondCount();
        int pBondCount = mol2.getBondCount();
        int rAtomCount = mol1.getAtomCount();
        int pAtomCount = mol2.getAtomCount();
        if (rBondCount == 0 && rAtomCount > 0 || pBondCount == 0 && pAtomCount > 0) {
            this.singleMapping();
        } else {
            this.chooseAlgorithm();
        }
    }

    private synchronized void chooseAlgorithm() {
        switch (this.algorithmType) {
            case CDKMCS: {
                this.cdkMCSAlgorithm();
                break;
            }
            case DEFAULT: {
                this.defaultMCSAlgorithm();
                break;
            }
            case MCSPlus: {
                this.mcsPlusAlgorithm();
                break;
            }
            case VFLibMCS: {
                this.vfLibMCSAlgorithm();
            }
        }
    }

    private synchronized boolean cdkMCSAlgorithm() {
        CDKMCSHandler mcs = this.getQuery() instanceof IQueryAtomContainer ? new CDKMCSHandler(this.getQuery(), this.getTarget()) : new CDKMCSHandler(this.getQuery(), this.getTarget(), this.isMatchBonds(), this.isMatchRings(), this.isMatchAtomType());
        this.clearMaps();
        this.getMCSList().addAll(mcs.getAllAtomMapping());
        return mcs.isTimeout();
    }

    private synchronized boolean mcsPlusAlgorithm() {
        MCSPlusHandler mcs = this.getQuery() instanceof IQueryAtomContainer ? new MCSPlusHandler((IQueryAtomContainer)this.getQuery(), this.getTarget()) : new MCSPlusHandler(this.getQuery(), this.getTarget(), this.isMatchBonds(), this.isMatchRings(), this.isMatchAtomType());
        this.clearMaps();
        this.getMCSList().addAll(mcs.getAllAtomMapping());
        return mcs.isTimeout();
    }

    private synchronized boolean substructureAlgorithm() throws CDKException {
        Substructure mcs = this.getQuery() instanceof IQueryAtomContainer ? new Substructure((IQueryAtomContainer)this.getQuery(), this.getTarget(), true) : new Substructure(this.getQuery(), this.getTarget(), this.isMatchBonds(), this.isMatchRings(), this.isMatchAtomType(), true);
        this.clearMaps();
        if (mcs.isSubgraph()) {
            this.getMCSList().addAll(mcs.getAllAtomMapping());
        }
        return mcs.isSubgraph();
    }

    private synchronized void vfLibMCSAlgorithm() {
        VF2MCS mcs = this.getQuery() instanceof IQueryAtomContainer ? new VF2MCS((IQueryAtomContainer)this.getQuery(), this.getTarget()) : new VF2MCS(this.getQuery(), this.getTarget(), this.isMatchBonds(), this.isMatchRings(), this.isMatchAtomType());
        this.clearMaps();
        this.getMCSList().addAll(mcs.getAllAtomMapping());
    }

    private synchronized void singleMapping() {
        SingleMappingHandler mcs = new SingleMappingHandler(this.getQuery(), this.getTarget(), this.isMatchRings());
        this.clearMaps();
        this.getMCSList().addAll(mcs.getAllAtomMapping());
    }

    private synchronized void defaultMCSAlgorithm() {
        try {
            boolean substructureAlgorithm = this.substructureAlgorithm();
            if (!substructureAlgorithm) {
                boolean timeoutMCS1 = this.cdkMCSAlgorithm();
                if (this.getMappingCount() == 0 && timeoutMCS1 || timeoutMCS1 && this.getMappingCount() > 0 && (this.getFirstAtomMapping().getCount() != this.getQuery().getAtomCount() || this.getFirstAtomMapping().getCount() != this.getTarget().getAtomCount())) {
                    this.vfLibMCSAlgorithm();
                }
            }
        }
        catch (CDKException e) {
            logger.error(Level.SEVERE, null, e);
        }
    }

    @Override
    public synchronized boolean isSubgraph() {
        if (this.getMappingCount() <= 0) {
            return false;
        }
        float mappingSize = this.getAllAtomMapping().iterator().next().getCount();
        int sourceAtomCount = this.getQuery().getAtomCount();
        int targetAtomCount = this.getTarget().getAtomCount();
        if (mappingSize == (float)sourceAtomCount && mappingSize <= (float)targetAtomCount) {
            if (mappingSize == 1.0f) {
                return true;
            }
            if (!this.getAllBondMaps().isEmpty() && this.getAllBondMaps().iterator().next().size() == this.getQuery().getBondCount()) {
                return true;
            }
        }
        return false;
    }

    public double getBondSensitiveMcGregorOut() {
        return this.bondSensitiveMcGregorOut;
    }

    public void setBondSenSitiveMcGregorOut(double bondSensitiveMcGregorOut) {
        this.bondSensitiveMcGregorOut = bondSensitiveMcGregorOut;
    }

    public double getBondInSensitiveMcGregor() {
        return this.bondInSensitiveMcGregor;
    }

    public void setBondInSenSitiveMcGregor(double bondInSensitiveMcGregor) {
        this.bondInSensitiveMcGregor = bondInSensitiveMcGregor;
    }
}

