/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.smsd;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.smsd.AtomAtomMapping;
import org.openscience.smsd.filters.ChemicalFilters;
import org.openscience.smsd.interfaces.IAtomMapping;

public class BaseMapping
extends ChemicalFilters
implements IAtomMapping {
    private final boolean matchBonds;
    private final boolean matchRings;
    private final boolean matchAtomType;
    private boolean subgraph;
    private List<Double> stereoScoreList;
    private List<Integer> fragmentSizeList;
    private List<Double> bondEnergiesList;
    private static final ILoggingTool Logger = LoggingToolFactory.createLoggingTool(BaseMapping.class);

    public BaseMapping(IAtomContainer mol1, IAtomContainer mol2, boolean matchBonds, boolean matchRings, boolean matchAtomType) {
        super(mol1, mol2);
        this.matchBonds = matchBonds;
        this.matchRings = matchRings;
        this.matchAtomType = matchAtomType;
    }

    public BaseMapping(IQueryAtomContainer mol1, IAtomContainer mol2) {
        super(mol1, mol2);
        this.matchBonds = true;
        this.matchRings = true;
        this.matchAtomType = true;
    }

    @Override
    public synchronized void setChemFilters(boolean stereoFilter, boolean fragmentFilter, boolean energyFilter) {
        if (this.getMappingCount() > 0) {
            if (energyFilter) {
                try {
                    this.sortResultsByEnergies();
                    this.bondEnergiesList = this.getSortedEnergy();
                }
                catch (CDKException ex) {
                    Logger.error(Level.SEVERE, null, ex);
                }
            }
            if (fragmentFilter) {
                this.sortResultsByFragments();
                this.fragmentSizeList = this.getSortedFragment();
            }
            if (stereoFilter) {
                try {
                    this.sortResultsByStereoAndBondMatch();
                    this.stereoScoreList = this.getStereoMatches();
                }
                catch (CDKException ex) {
                    Logger.error(Level.SEVERE, null, ex);
                }
            }
        }
    }

    @Override
    public synchronized Integer getFragmentSize(int Key2) {
        return this.fragmentSizeList != null && !this.fragmentSizeList.isEmpty() ? this.fragmentSizeList.get(Key2) : null;
    }

    @Override
    public synchronized Integer getStereoScore(int Key2) {
        return this.stereoScoreList != null && !this.stereoScoreList.isEmpty() ? Integer.valueOf(this.stereoScoreList.get(Key2).intValue()) : null;
    }

    @Override
    public synchronized Double getEnergyScore(int Key2) {
        return this.bondEnergiesList != null && !this.bondEnergiesList.isEmpty() ? this.bondEnergiesList.get(Key2) : null;
    }

    @Override
    public synchronized double getTanimotoSimilarity() {
        AtomAtomMapping firstAtomMCS;
        int decimalPlaces = 4;
        double tanimotoAtom = 0.0;
        if (this.getMappingCount() > 0 && !(firstAtomMCS = this.getMCSList().iterator().next()).isEmpty()) {
            double rAtomCount = this.getMCSList().iterator().next().getQuery().getAtomCount();
            double pAtomCount = this.getMCSList().iterator().next().getTarget().getAtomCount();
            double matchCount = firstAtomMCS.getCount();
            tanimotoAtom = matchCount / (rAtomCount + pAtomCount - matchCount);
            BigDecimal tan = new BigDecimal(tanimotoAtom);
            tan = tan.setScale(decimalPlaces, 4);
            tanimotoAtom = tan.doubleValue();
        }
        return tanimotoAtom;
    }

    @Override
    public synchronized boolean isStereoMisMatch() {
        boolean flag = false;
        IAtomContainer reactant = this.getQuery();
        IAtomContainer product = this.getTarget();
        int stereoMisMatchScore = 0;
        if (this.getMappingCount() > 0) {
            AtomAtomMapping firstAtomMCS = this.getMCSList().iterator().next();
            for (IAtom indexI : firstAtomMCS.getMappingsByAtoms().keySet()) {
                IAtom indexJ = firstAtomMCS.getMappingsByAtoms().get(indexI);
                for (IAtom indexIPlus : firstAtomMCS.getMappingsByAtoms().keySet()) {
                    IAtom indexJPlus = firstAtomMCS.getMappingsByAtoms().get(indexIPlus);
                    if (indexI.equals(indexIPlus) || indexJ.equals(indexJPlus)) continue;
                    IAtom sourceAtom1 = indexI;
                    IAtom sourceAtom2 = indexIPlus;
                    IBond rBond = reactant.getBond(sourceAtom1, sourceAtom2);
                    IAtom targetAtom1 = indexJ;
                    IAtom targetAtom2 = indexJPlus;
                    IBond pBond = product.getBond(targetAtom1, targetAtom2);
                    if (rBond == null || pBond == null || rBond.getStereo() == pBond.getStereo()) continue;
                    ++stereoMisMatchScore;
                }
            }
        }
        if (stereoMisMatchScore > 0) {
            flag = true;
        }
        return flag;
    }

    @Override
    public synchronized int getMappingCount() {
        return this.getMCSList().isEmpty() ? 0 : this.getMCSList().size();
    }

    @Override
    public synchronized double getEuclideanDistance() {
        AtomAtomMapping firstAtomMCS;
        int decimalPlaces = 4;
        double euclidean = -1.0;
        if (this.getMappingCount() > 0 && !(firstAtomMCS = this.getMCSList().iterator().next()).isEmpty()) {
            double sourceAtomCount = this.getMCSList().iterator().next().getQuery().getAtomCount();
            double targetAtomCount = this.getMCSList().iterator().next().getTarget().getAtomCount();
            double common = firstAtomMCS.getCount();
            euclidean = Math.sqrt(sourceAtomCount + targetAtomCount - 2.0 * common);
            BigDecimal dist = new BigDecimal(euclidean);
            dist = dist.setScale(decimalPlaces, 4);
            euclidean = dist.doubleValue();
        }
        return euclidean;
    }

    @Override
    public synchronized List<AtomAtomMapping> getAllAtomMapping() {
        return Collections.unmodifiableList(new ArrayList<AtomAtomMapping>(this.getMCSList()));
    }

    @Override
    public synchronized AtomAtomMapping getFirstAtomMapping() {
        return this.getMCSList().isEmpty() ? new AtomAtomMapping(this.getQuery(), this.getTarget()) : this.getMCSList().iterator().next();
    }

    protected synchronized boolean isMatchBonds() {
        return this.matchBonds;
    }

    protected synchronized boolean isMatchRings() {
        return this.matchRings;
    }

    public synchronized boolean isSubgraph() {
        return this.subgraph;
    }

    public synchronized void clearMaps() {
        this.getMCSList().clear();
    }

    public synchronized List<Map<IBond, IBond>> getAllBondMaps() {
        if (!this.getMCSList().isEmpty()) {
            return this.makeBondMapsOfAtomMaps(this.getQuery(), this.getTarget(), this.getMCSList());
        }
        return new ArrayList<Map<IBond, IBond>>();
    }

    public synchronized void setSubgraph(boolean subgraph) {
        this.subgraph = subgraph;
    }

    public synchronized List<Map<IBond, IBond>> makeBondMapsOfAtomMaps(IAtomContainer ac1, IAtomContainer ac2, List<AtomAtomMapping> mappings) {
        List<Map<IBond, IBond>> bondMaps = Collections.synchronizedList(new ArrayList());
        for (AtomAtomMapping mapping : mappings) {
            bondMaps.add(this.makeBondMapOfAtomMap(ac1, ac2, mapping));
        }
        return bondMaps;
    }

    private synchronized Map<IBond, IBond> makeBondMapOfAtomMap(IAtomContainer ac1, IAtomContainer ac2, AtomAtomMapping mapping) {
        Map<IBond, IBond> bondbondMappingMap = Collections.synchronizedMap(new HashMap());
        for (Map.Entry<IAtom, IAtom> map1 : mapping.getMappingsByAtoms().entrySet()) {
            for (Map.Entry<IAtom, IAtom> map2 : mapping.getMappingsByAtoms().entrySet()) {
                if (map1.getKey() == map2.getKey()) continue;
                IBond bond1 = ac1.getBond(map1.getKey(), map2.getKey());
                IBond bond2 = ac2.getBond(map1.getValue(), map2.getValue());
                if (bond1 == null || bond2 == null || bondbondMappingMap.containsKey(bond1)) continue;
                bondbondMappingMap.put(bond1, bond2);
            }
        }
        return bondbondMappingMap;
    }

    public boolean isMatchAtomType() {
        return this.matchAtomType;
    }
}

