/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.tools.manipulator;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.atomtype.CDKAtomTypeMatcher;
import org.openscience.cdk.config.Elements;
import org.openscience.cdk.config.Isotopes;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IDoubleBondStereochemistry;
import org.openscience.cdk.interfaces.IElectronContainer;
import org.openscience.cdk.interfaces.ILonePair;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.interfaces.ISingleElectron;
import org.openscience.cdk.interfaces.IStereoElement;
import org.openscience.cdk.interfaces.ITetrahedralChirality;
import org.openscience.cdk.ringsearch.RingSearch;
import org.openscience.cdk.stereo.DoubleBondStereochemistry;
import org.openscience.cdk.stereo.TetrahedralChirality;
import org.openscience.cdk.tools.manipulator.AtomTypeManipulator;
import org.openscience.cdk.tools.manipulator.BondManipulator;

public class AtomContainerManipulator {
    public static IAtomContainer extractSubstructure(IAtomContainer atomContainer, int ... atomIndices) throws CloneNotSupportedException {
        IAtomContainer substructure = atomContainer.clone();
        int numberOfAtoms = substructure.getAtomCount();
        IAtom[] atoms = new IAtom[numberOfAtoms];
        for (int atomIndex = 0; atomIndex < numberOfAtoms; ++atomIndex) {
            atoms[atomIndex] = substructure.getAtom(atomIndex);
        }
        Arrays.sort(atomIndices);
        for (int index = 0; index < numberOfAtoms; ++index) {
            if (Arrays.binarySearch(atomIndices, index) >= 0) continue;
            IAtom atom = atoms[index];
            substructure.removeAtomAndConnectedElectronContainers(atom);
        }
        return substructure;
    }

    public static IAtom getAtomById(IAtomContainer ac, String id) throws CDKException {
        for (int i = 0; i < ac.getAtomCount(); ++i) {
            if (ac.getAtom(i).getID() == null || !ac.getAtom(i).getID().equals(id)) continue;
            return ac.getAtom(i);
        }
        throw new CDKException("no suc atom");
    }

    public static boolean replaceAtomByAtom(IAtomContainer container, IAtom oldAtom, IAtom newAtom) {
        HashMap<IAtom, IAtom> atomremap = new HashMap<IAtom, IAtom>();
        for (int i = 0; i < container.getAtomCount(); ++i) {
            IAtom atom = container.getAtom(i);
            if (atom == oldAtom) {
                container.setAtom(i, newAtom);
                atomremap.put(oldAtom, newAtom);
                continue;
            }
            atomremap.put(atom, atom);
        }
        if (!atomremap.containsKey(oldAtom)) {
            return false;
        }
        HashMap<IBond, IBond> bondremap = new HashMap<IBond, IBond>();
        for (IBond bond : container.bonds()) {
            bondremap.put(bond, bond);
            for (int i = 0; i < bond.getAtomCount(); ++i) {
                if (bond.getAtom(i) != oldAtom) continue;
                bond.setAtom(newAtom, i);
            }
        }
        for (ISingleElectron ec : container.singleElectrons()) {
            if (ec.getAtom() != oldAtom) continue;
            ec.setAtom(newAtom);
        }
        for (ILonePair lp : container.lonePairs()) {
            if (lp.getAtom() != oldAtom) continue;
            lp.setAtom(newAtom);
        }
        ArrayList<IStereoElement> stereoremapped = new ArrayList<IStereoElement>();
        for (IStereoElement se : container.stereoElements()) {
            stereoremapped.add(se.map(atomremap, bondremap));
        }
        container.setStereoElements(stereoremapped);
        return true;
    }

    public static double getTotalCharge(IAtomContainer atomContainer) {
        double charge = 0.0;
        for (IAtom atom : atomContainer.atoms()) {
            Double thisCharge = atom.getCharge();
            if (thisCharge == CDKConstants.UNSET) continue;
            charge += thisCharge.doubleValue();
        }
        return charge;
    }

    public static double getTotalExactMass(IAtomContainer atomContainer) {
        try {
            Isotopes isotopes = Isotopes.getInstance();
            double mass = 0.0;
            double hExactMass = isotopes.getMajorIsotope(1).getExactMass();
            for (IAtom atom : atomContainer.atoms()) {
                if (atom.getImplicitHydrogenCount() == null) {
                    throw new IllegalArgumentException("an atom had with unknown (null) implicit hydrogens");
                }
                mass += atom.getExactMass().doubleValue();
                mass += (double)atom.getImplicitHydrogenCount().intValue() * hExactMass;
            }
            return mass;
        }
        catch (IOException e) {
            throw new RuntimeException("Isotopes definitions could not be loaded", e);
        }
    }

    public static double getNaturalExactMass(IAtomContainer atomContainer) {
        try {
            Isotopes isotopes = Isotopes.getInstance();
            double hydgrogenMass = isotopes.getNaturalMass(Elements.HYDROGEN);
            double mass = 0.0;
            for (IAtom atom : atomContainer.atoms()) {
                if (atom.getAtomicNumber() == null) {
                    throw new IllegalArgumentException("an atom had with unknown (null) atomic number");
                }
                if (atom.getImplicitHydrogenCount() == null) {
                    throw new IllegalArgumentException("an atom had with unknown (null) implicit hydrogens");
                }
                mass += isotopes.getNaturalMass(Elements.ofNumber(atom.getAtomicNumber()).toIElement());
                mass += hydgrogenMass * (double)atom.getImplicitHydrogenCount().intValue();
            }
            return mass;
        }
        catch (IOException e) {
            throw new RuntimeException("Isotopes definitions could not be loaded", e);
        }
    }

    public static double getTotalNaturalAbundance(IAtomContainer atomContainer) {
        try {
            Isotopes isotopes = Isotopes.getInstance();
            double abundance = 1.0;
            double hAbundance = isotopes.getMajorIsotope(1).getNaturalAbundance();
            int nImplH = 0;
            for (IAtom atom : atomContainer.atoms()) {
                if (atom.getImplicitHydrogenCount() == null) {
                    throw new IllegalArgumentException("an atom had with unknown (null) implicit hydrogens");
                }
                abundance *= atom.getNaturalAbundance().doubleValue();
                for (int h = 0; h < atom.getImplicitHydrogenCount(); ++h) {
                    abundance *= hAbundance;
                }
                nImplH += atom.getImplicitHydrogenCount().intValue();
            }
            return abundance / Math.pow(100.0, nImplH + atomContainer.getAtomCount());
        }
        catch (IOException e) {
            throw new RuntimeException("Isotopes definitions could not be loaded", e);
        }
    }

    public static int getTotalFormalCharge(IAtomContainer atomContainer) {
        int chargeP = AtomContainerManipulator.getTotalNegativeFormalCharge(atomContainer);
        int chargeN = AtomContainerManipulator.getTotalPositiveFormalCharge(atomContainer);
        return chargeP + chargeN;
    }

    public static int getTotalNegativeFormalCharge(IAtomContainer atomContainer) {
        int charge = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            double chargeI = atomContainer.getAtom(i).getFormalCharge().intValue();
            if (!(chargeI < 0.0)) continue;
            charge = (int)((double)charge + chargeI);
        }
        return charge;
    }

    public static int getTotalPositiveFormalCharge(IAtomContainer atomContainer) {
        int charge = 0;
        for (int i = 0; i < atomContainer.getAtomCount(); ++i) {
            double chargeI = atomContainer.getAtom(i).getFormalCharge().intValue();
            if (!(chargeI > 0.0)) continue;
            charge = (int)((double)charge + chargeI);
        }
        return charge;
    }

    public static int getTotalHydrogenCount(IAtomContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("null container provided");
        }
        int hydrogens = 0;
        for (IAtom atom : container.atoms()) {
            Integer implicit;
            if (Elements.HYDROGEN.getSymbol().equals(atom.getSymbol())) {
                ++hydrogens;
            }
            if ((implicit = atom.getImplicitHydrogenCount()) == null) continue;
            hydrogens += implicit.intValue();
        }
        return hydrogens;
    }

    public static int getImplicitHydrogenCount(IAtomContainer container) {
        if (container == null) {
            throw new IllegalArgumentException("null container provided");
        }
        int count = 0;
        for (IAtom atom : container.atoms()) {
            Integer implicit = atom.getImplicitHydrogenCount();
            if (implicit == null) continue;
            count += implicit.intValue();
        }
        return count;
    }

    public static int countExplicitHydrogens(IAtomContainer atomContainer, IAtom atom) {
        if (atomContainer == null || atom == null) {
            throw new IllegalArgumentException("null container or atom provided");
        }
        int hCount = 0;
        for (IAtom connected : atomContainer.getConnectedAtomsList(atom)) {
            if (!Elements.HYDROGEN.getSymbol().equals(connected.getSymbol())) continue;
            ++hCount;
        }
        return hCount;
    }

    public static void convertImplicitToExplicitHydrogens(IAtomContainer atomContainer) {
        ArrayList<IAtom> hydrogens = new ArrayList<IAtom>();
        ArrayList<IBond> newBonds = new ArrayList<IBond>();
        HashMap<IAtom, IAtom> hNeighbor = Maps.newHashMapWithExpectedSize(atomContainer.getAtomCount());
        for (IAtom atom : atomContainer.atoms()) {
            Integer hCount;
            if (atom.getSymbol().equals("H") || (hCount = atom.getImplicitHydrogenCount()) == null) continue;
            for (int i = 0; i < hCount; ++i) {
                IAtom hydrogen = atom.getBuilder().newInstance(IAtom.class, "H");
                hydrogen.setAtomTypeName("H");
                hydrogen.setImplicitHydrogenCount(0);
                hydrogens.add(hydrogen);
                newBonds.add(atom.getBuilder().newInstance(IBond.class, new Object[]{atom, hydrogen, IBond.Order.SINGLE}));
                if (hNeighbor.get(atom) != null) continue;
                hNeighbor.put(atom, hydrogen);
            }
            atom.setImplicitHydrogenCount(0);
        }
        for (IAtom atom : hydrogens) {
            atomContainer.addAtom(atom);
        }
        for (IBond bond : newBonds) {
            atomContainer.addBond(bond);
        }
        block4: for (IStereoElement se : atomContainer.stereoElements()) {
            if (!(se instanceof ITetrahedralChirality)) continue;
            ITetrahedralChirality tc = (ITetrahedralChirality)se;
            IAtom focus = tc.getChiralAtom();
            IAtom[] neighbors = tc.getLigands();
            IAtom hydrogen = (IAtom)hNeighbor.get(focus);
            if (hydrogen == null) continue;
            for (int i = 0; i < tc.getLigands().length; ++i) {
                if (neighbors[i] != focus) continue;
                neighbors[i] = hydrogen;
                continue block4;
            }
        }
    }

    public static int countHydrogens(IAtomContainer atomContainer, IAtom atom) {
        int hCount = atom.getImplicitHydrogenCount() == CDKConstants.UNSET ? 0 : atom.getImplicitHydrogenCount();
        return hCount += AtomContainerManipulator.countExplicitHydrogens(atomContainer, atom);
    }

    public static List<String> getAllIDs(IAtomContainer mol) {
        ArrayList<String> idList = new ArrayList<String>();
        if (mol != null) {
            if (mol.getID() != null) {
                idList.add(mol.getID());
            }
            for (IAtom atom : mol.atoms()) {
                if (atom.getID() == null) continue;
                idList.add(atom.getID());
            }
            for (IBond bond : mol.bonds()) {
                if (bond.getID() == null) continue;
                idList.add(bond.getID());
            }
        }
        return idList;
    }

    public static IAtomContainer removeNonChiralHydrogens(IAtomContainer org) {
        HashMap<IAtom, IAtom> map = new HashMap<IAtom, IAtom>();
        ArrayList<IAtom> remove = new ArrayList<IAtom>();
        IAtomContainer cpy = org.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        int count = org.getAtomCount();
        for (int i = 0; i < count; ++i) {
            IAtom neighbour;
            Integer stereoParity;
            IAtom atom = org.getAtom(i);
            boolean addToRemove = false;
            if (AtomContainerManipulator.suppressibleHydrogen(org, atom) && org.getConnectedAtomsList(atom).size() == 1 && ((stereoParity = (neighbour = org.getConnectedAtomsList(atom).get(0)).getStereoParity()) == null || stereoParity == 0)) {
                addToRemove = true;
                for (IBond bond : org.getConnectedBondsList(neighbour)) {
                    IAtom neighboursNeighbour;
                    IBond.Stereo bondStereo = bond.getStereo();
                    if (bondStereo != null && bondStereo != IBond.Stereo.NONE) {
                        addToRemove = false;
                    }
                    if (!(neighboursNeighbour = bond.getConnectedAtom(neighbour)).getSymbol().equals("H") || neighboursNeighbour == atom) continue;
                    addToRemove = true;
                    break;
                }
            }
            if (addToRemove) {
                remove.add(atom);
                continue;
            }
            AtomContainerManipulator.addClone(atom, cpy, map);
        }
        for (IStereoElement stereoElement : org.stereoElements()) {
            if (stereoElement instanceof ITetrahedralChirality) {
                ITetrahedralChirality tetChirality = (ITetrahedralChirality)stereoElement;
                for (IAtom atom : tetChirality.getLigands()) {
                    if (!atom.getSymbol().equals("H") || !remove.contains(atom)) continue;
                    remove.remove(atom);
                    AtomContainerManipulator.addClone(atom, cpy, map);
                }
                continue;
            }
            if (!(stereoElement instanceof IDoubleBondStereochemistry)) continue;
            IDoubleBondStereochemistry dbs = (IDoubleBondStereochemistry)stereoElement;
            IBond stereoBond = dbs.getStereoBond();
            for (IAtom neighbor : org.getConnectedAtomsList(stereoBond.getAtom(0))) {
                if (!remove.remove(neighbor)) continue;
                AtomContainerManipulator.addClone(neighbor, cpy, map);
            }
            for (IAtom neighbor : org.getConnectedAtomsList(stereoBond.getAtom(1))) {
                if (!remove.remove(neighbor)) continue;
                AtomContainerManipulator.addClone(neighbor, cpy, map);
            }
        }
        count = org.getBondCount();
        for (int i = 0; i < count; ++i) {
            IBond bond = org.getBond(i);
            boolean removedBond = false;
            int length = bond.getAtomCount();
            for (int k = 0; k < length; ++k) {
                if (!remove.contains(bond.getAtom(k))) continue;
                removedBond = true;
                break;
            }
            if (removedBond) continue;
            IBond clone = null;
            try {
                clone = org.getBond(i).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            assert (clone != null);
            clone.setAtoms(new IAtom[]{(IAtom)map.get(bond.getAtom(0)), (IAtom)map.get(bond.getAtom(1))});
            cpy.addBond(clone);
        }
        for (IAtom aRemove : remove) {
            for (IAtom iAtom : org.getConnectedAtomsList(aRemove)) {
                IAtom neighb = (IAtom)map.get(iAtom);
                if (neighb == null) continue;
                neighb.setImplicitHydrogenCount((neighb.getImplicitHydrogenCount() == null ? 0 : neighb.getImplicitHydrogenCount()) + 1);
            }
        }
        for (IAtom atom : cpy.atoms()) {
            if (atom.getImplicitHydrogenCount() != null) continue;
            atom.setImplicitHydrogenCount(0);
        }
        cpy.addProperties(org.getProperties());
        cpy.setFlags(org.getFlags());
        return cpy;
    }

    private static void addClone(IAtom atom, IAtomContainer mol, Map<IAtom, IAtom> map) {
        IAtom clonedAtom = null;
        try {
            clonedAtom = atom.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        mol.addAtom(clonedAtom);
        map.put(atom, clonedAtom);
    }

    public static IAtomContainer copyAndSuppressedHydrogens(IAtomContainer org) {
        try {
            return AtomContainerManipulator.suppressHydrogens(org.clone());
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("atom container could not be cloned");
        }
    }

    public static IAtomContainer suppressHydrogens(IAtomContainer org) {
        HashSet<IElectronContainer> remove;
        boolean anyHydrogenPresent = false;
        for (IAtom atom : org.atoms()) {
            if (!"H".equals(atom.getSymbol())) continue;
            anyHydrogenPresent = true;
            break;
        }
        if (!anyHydrogenPresent) {
            return org;
        }
        int[][] graph = GraphUtil.toAdjList(org);
        int nOrgAtoms = org.getAtomCount();
        int nOrgBonds = org.getBondCount();
        int nCpyAtoms = 0;
        int nCpyBonds = 0;
        HashSet<IAtom> hydrogens = new HashSet<IAtom>(nOrgAtoms);
        IAtom[] cpyAtoms = new IAtom[nOrgAtoms];
        for (int v = 0; v < nOrgAtoms; ++v) {
            IAtom atom = org.getAtom(v);
            if (AtomContainerManipulator.suppressibleHydrogen(org, graph, v)) {
                hydrogens.add(atom);
                AtomContainerManipulator.incrementImplHydrogenCount(org.getAtom(graph[v][0]));
                continue;
            }
            cpyAtoms[nCpyAtoms++] = atom;
        }
        if (hydrogens.isEmpty()) {
            return org;
        }
        org.setAtoms(Arrays.copyOf(cpyAtoms, nCpyAtoms));
        IBond[] cpyBonds = new IBond[nOrgBonds - hydrogens.size()];
        int remaining = hydrogens.size();
        for (IBond bond : org.bonds()) {
            if (remaining > 0 && (hydrogens.contains(bond.getAtom(0)) || hydrogens.contains(bond.getAtom(1)))) {
                --remaining;
                continue;
            }
            cpyBonds[nCpyBonds++] = bond;
        }
        if (nCpyBonds != cpyBonds.length) {
            throw new IllegalArgumentException("number of removed bonds was less than the number of removed hydrogens");
        }
        org.setBonds(cpyBonds);
        ArrayList<IStereoElement> elements = new ArrayList<IStereoElement>();
        for (IStereoElement se : org.stereoElements()) {
            if (se instanceof ITetrahedralChirality) {
                ITetrahedralChirality iTetrahedralChirality = (ITetrahedralChirality)se;
                IAtom focus = iTetrahedralChirality.getChiralAtom();
                IAtom[] neighbors = iTetrahedralChirality.getLigands();
                boolean updated = false;
                for (int i = 0; i < neighbors.length; ++i) {
                    if (!hydrogens.contains(neighbors[i])) continue;
                    neighbors[i] = focus;
                    updated = true;
                }
                if (!updated) {
                    elements.add(iTetrahedralChirality);
                    continue;
                }
                elements.add(new TetrahedralChirality(focus, neighbors, iTetrahedralChirality.getStereo()));
                continue;
            }
            if (!(se instanceof IDoubleBondStereochemistry)) continue;
            IDoubleBondStereochemistry iDoubleBondStereochemistry = (IDoubleBondStereochemistry)se;
            IDoubleBondStereochemistry.Conformation conformation = iDoubleBondStereochemistry.getStereo();
            IBond orgStereo = iDoubleBondStereochemistry.getStereoBond();
            IBond orgLeft = iDoubleBondStereochemistry.getBonds()[0];
            IBond orgRight = iDoubleBondStereochemistry.getBonds()[1];
            IAtom u = orgStereo.getAtom(0);
            IAtom v = orgStereo.getAtom(1);
            IAtom x = orgLeft.getConnectedAtom(u);
            IAtom y = orgRight.getConnectedAtom(v);
            IAtom xNew = x;
            IAtom yNew = y;
            if (hydrogens.contains(x)) {
                conformation = conformation.invert();
                xNew = AtomContainerManipulator.findOther(org, u, v, x);
            }
            if (hydrogens.contains(y)) {
                conformation = conformation.invert();
                yNew = AtomContainerManipulator.findOther(org, v, u, y);
            }
            if (x == null || y == null) continue;
            if (x == xNew && y == yNew) {
                elements.add(iDoubleBondStereochemistry);
                continue;
            }
            IBond cpyLeft = xNew != x ? org.getBond(u, xNew) : orgLeft;
            IBond cpyRight = yNew != y ? org.getBond(v, yNew) : orgRight;
            elements.add(new DoubleBondStereochemistry(orgStereo, new IBond[]{cpyLeft, cpyRight}, conformation));
        }
        org.setStereoElements(elements);
        if (org.getSingleElectronCount() > 0) {
            remove = new HashSet<IElectronContainer>();
            for (ISingleElectron iSingleElectron : org.singleElectrons()) {
                if (hydrogens.contains(iSingleElectron.getAtom())) continue;
                remove.add(iSingleElectron);
            }
            for (ISingleElectron iSingleElectron : remove) {
                org.removeSingleElectron(iSingleElectron);
            }
        }
        if (org.getLonePairCount() > 0) {
            remove = new HashSet();
            for (ILonePair iLonePair : org.lonePairs()) {
                if (hydrogens.contains(iLonePair.getAtom())) continue;
                remove.add(iLonePair);
            }
            for (ILonePair iLonePair : remove) {
                org.removeLonePair(iLonePair);
            }
        }
        return org;
    }

    public static IAtomContainer removeHydrogens(IAtomContainer org) {
        return AtomContainerManipulator.copyAndSuppressedHydrogens(org);
    }

    private static boolean suppressibleHydrogen(IAtomContainer container, IAtom atom) {
        if (!"H".equals(atom.getSymbol())) {
            return false;
        }
        if (atom.getFormalCharge() != null && atom.getFormalCharge() != 0) {
            return false;
        }
        if (atom.getMassNumber() != null && atom.getMassNumber() != 1) {
            return false;
        }
        if (atom.getImplicitHydrogenCount() != null && atom.getImplicitHydrogenCount() != 0) {
            return false;
        }
        List<IAtom> neighbors = container.getConnectedAtomsList(atom);
        return neighbors.size() != 1 || !neighbors.get(0).getSymbol().equals("H");
    }

    private static void incrementImplHydrogenCount(IAtom atom) {
        Integer hCount = atom.getImplicitHydrogenCount();
        if (hCount == null) {
            if (!(atom instanceof IPseudoAtom)) {
                throw new IllegalArgumentException("a non-pseudo atom had an unset hydrogen count");
            }
            hCount = 0;
        }
        atom.setImplicitHydrogenCount(hCount + 1);
    }

    private static boolean suppressibleHydrogen(IAtomContainer container, int[][] graph, int v) {
        IAtom atom = container.getAtom(v);
        if (!"H".equals(atom.getSymbol())) {
            return false;
        }
        if (atom.getFormalCharge() != null && atom.getFormalCharge() != 0) {
            return false;
        }
        if (atom.getMassNumber() != null && atom.getMassNumber() != 1) {
            return false;
        }
        if (graph[v].length != 1) {
            return false;
        }
        return !"H".equals(container.getAtom(graph[v][0]).getSymbol());
    }

    private static IAtom findOther(IAtomContainer container, IAtom atom, IAtom exclude1, IAtom exclude2) {
        for (IAtom neighbor : container.getConnectedAtomsList(atom)) {
            if (neighbor == exclude1 || neighbor == exclude2) continue;
            return neighbor;
        }
        return null;
    }

    @Deprecated
    public static IAtomContainer removeHydrogensPreserveMultiplyBonded(IAtomContainer ac) {
        return AtomContainerManipulator.copyAndSuppressedHydrogens(ac);
    }

    @Deprecated
    private static IAtomContainer removeHydrogens(IAtomContainer ac, List<IAtom> preserve) {
        int i;
        HashMap<IAtom, IAtom> map = new HashMap<IAtom, IAtom>();
        ArrayList<IAtom> remove = new ArrayList<IAtom>();
        IAtomContainer mol = ac.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        int count = ac.getAtomCount();
        for (i = 0; i < count; ++i) {
            IAtom atom = ac.getAtom(i);
            if (!AtomContainerManipulator.suppressibleHydrogen(ac, atom) || preserve.contains(atom)) {
                IAtom a = null;
                try {
                    a = atom.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                a.setImplicitHydrogenCount(0);
                mol.addAtom(a);
                map.put(atom, a);
                continue;
            }
            remove.add(atom);
        }
        count = ac.getBondCount();
        for (i = 0; i < count; ++i) {
            IBond bond = ac.getBond(i);
            IAtom atom0 = bond.getAtom(0);
            IAtom atom1 = bond.getAtom(1);
            boolean remove_bond = false;
            for (IAtom atom : bond.atoms()) {
                if (!remove.contains(atom)) continue;
                remove_bond = true;
                break;
            }
            if (remove_bond) continue;
            IBond clone = null;
            try {
                clone = ac.getBond(i).clone();
            }
            catch (CloneNotSupportedException e) {
                e.printStackTrace();
            }
            clone.setAtoms(new IAtom[]{(IAtom)map.get(atom0), (IAtom)map.get(atom1)});
            mol.addBond(clone);
        }
        for (IAtom removeAtom : remove) {
            for (IAtom neighbor : ac.getConnectedAtomsList(removeAtom)) {
                IAtom neighb = (IAtom)map.get(neighbor);
                neighb.setImplicitHydrogenCount(neighb.getImplicitHydrogenCount() + 1);
            }
        }
        return mol;
    }

    public static void setAtomProperties(IAtomContainer container, Object propKey, Object propVal) {
        if (container != null) {
            for (IAtom atom : container.atoms()) {
                atom.setProperty(propKey, propVal);
            }
        }
    }

    public static void unregisterElectronContainerListeners(IAtomContainer container) {
        for (IElectronContainer electronContainer : container.electronContainers()) {
            electronContainer.removeListener(container);
        }
    }

    public static void unregisterAtomListeners(IAtomContainer container) {
        for (IAtom atom : container.atoms()) {
            atom.removeListener(container);
        }
    }

    public static IAtomContainer getIntersection(IAtomContainer container1, IAtomContainer container2) {
        int i;
        IAtomContainer intersection = container1.getBuilder().newInstance(IAtomContainer.class, new Object[0]);
        for (i = 0; i < container1.getAtomCount(); ++i) {
            if (!container2.contains(container1.getAtom(i))) continue;
            intersection.addAtom(container1.getAtom(i));
        }
        for (i = 0; i < container1.getElectronContainerCount(); ++i) {
            if (!container2.contains(container1.getElectronContainer(i))) continue;
            intersection.addElectronContainer(container1.getElectronContainer(i));
        }
        return intersection;
    }

    public static IAtom[] getAtomArray(IAtomContainer container) {
        IAtom[] ret = new IAtom[container.getAtomCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getAtom(i);
        }
        return ret;
    }

    public static IAtom[] getAtomArray(List<IAtom> list) {
        IAtom[] ret = new IAtom[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static IBond[] getBondArray(IAtomContainer container) {
        IBond[] ret = new IBond[container.getBondCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getBond(i);
        }
        return ret;
    }

    public static IBond[] getBondArray(List<IBond> list) {
        IBond[] ret = new IBond[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static IElectronContainer[] getElectronContainerArray(IAtomContainer container) {
        IElectronContainer[] ret = new IElectronContainer[container.getElectronContainerCount()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = container.getElectronContainer(i);
        }
        return ret;
    }

    public static IElectronContainer[] getElectronContainerArray(List<IElectronContainer> list) {
        IElectronContainer[] ret = new IElectronContainer[list.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = list.get(i);
        }
        return ret;
    }

    public static void percieveAtomTypesAndConfigureAtoms(IAtomContainer container) throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container.getBuilder());
        for (IAtom atom : container.atoms()) {
            IAtomType matched = matcher.findMatchingAtomType(container, atom);
            if (matched == null) continue;
            AtomTypeManipulator.configure(atom, matched);
        }
    }

    public static void percieveAtomTypesAndConfigureUnsetProperties(IAtomContainer container) throws CDKException {
        CDKAtomTypeMatcher matcher = CDKAtomTypeMatcher.getInstance(container.getBuilder());
        for (IAtom atom : container.atoms()) {
            IAtomType matched = matcher.findMatchingAtomType(container, atom);
            if (matched == null) continue;
            AtomTypeManipulator.configureUnsetProperties(atom, matched);
        }
    }

    public static void clearAtomConfigurations(IAtomContainer container) {
        for (IAtom atom : container.atoms()) {
            atom.setAtomTypeName((String)CDKConstants.UNSET);
            atom.setMaxBondOrder((IBond.Order)((Object)CDKConstants.UNSET));
            atom.setBondOrderSum((Double)CDKConstants.UNSET);
            atom.setCovalentRadius((Double)CDKConstants.UNSET);
            atom.setValency((Integer)CDKConstants.UNSET);
            atom.setFormalCharge((Integer)CDKConstants.UNSET);
            atom.setHybridization((IAtomType.Hybridization)((Object)CDKConstants.UNSET));
            atom.setFormalNeighbourCount((Integer)CDKConstants.UNSET);
            atom.setFlag(512, false);
            atom.setFlag(256, false);
            atom.setProperty("cdk:Chemical Group", CDKConstants.UNSET);
            atom.setFlag(32, false);
            atom.setProperty("org.openscience.cdk.renderer.color", CDKConstants.UNSET);
            atom.setExactMass((Double)CDKConstants.UNSET);
        }
    }

    public static int getSingleBondEquivalentSum(IAtomContainer container) {
        int sum = 0;
        for (IBond bond : container.bonds()) {
            IBond.Order order = bond.getOrder();
            if (order == null) continue;
            sum += order.numeric().intValue();
        }
        return sum;
    }

    public static IBond.Order getMaximumBondOrder(IAtomContainer container) {
        return BondManipulator.getMaximumBondOrder(container.bonds().iterator());
    }

    public static List<IAtom> getHeavyAtoms(IAtomContainer container) {
        ArrayList<IAtom> newAc = new ArrayList<IAtom>();
        for (int f = 0; f < container.getAtomCount(); ++f) {
            if (container.getAtom(f).getSymbol().equals("H")) continue;
            newAc.add(container.getAtom(f));
        }
        return newAc;
    }

    public static IAtomContainer createAllCarbonAllSingleNonAromaticBondAtomContainer(IAtomContainer atomContainer) throws CloneNotSupportedException {
        IAtomContainer query2 = atomContainer.clone();
        for (int i = 0; i < query2.getBondCount(); ++i) {
            query2.getBond(i).setOrder(IBond.Order.SINGLE);
            query2.getBond(i).setFlag(32, false);
            query2.getBond(i).setFlag(4096, false);
            query2.getBond(i).getAtom(0).setSymbol("C");
            query2.getBond(i).getAtom(0).setHybridization(null);
            query2.getBond(i).getAtom(1).setSymbol("C");
            query2.getBond(i).getAtom(1).setHybridization(null);
            query2.getBond(i).getAtom(0).setFlag(32, false);
            query2.getBond(i).getAtom(1).setFlag(32, false);
        }
        return query2;
    }

    public static IAtomContainer anonymise(IAtomContainer src) {
        int i;
        IChemObjectBuilder builder = src.getBuilder();
        IAtom[] atoms = new IAtom[src.getAtomCount()];
        IBond[] bonds = new IBond[src.getBondCount()];
        for (i = 0; i < atoms.length; ++i) {
            atoms[i] = builder.newInstance(IAtom.class, "C");
        }
        for (i = 0; i < bonds.length; ++i) {
            IBond bond = src.getBond(i);
            int u = src.getAtomNumber(bond.getAtom(0));
            int v = src.getAtomNumber(bond.getAtom(1));
            bonds[i] = builder.newInstance(IBond.class, atoms[u], atoms[v]);
        }
        IAtomContainer dest = builder.newInstance(IAtomContainer.class, 0, 0, 0, 0);
        dest.setAtoms(atoms);
        dest.setBonds(bonds);
        return dest;
    }

    public static IAtomContainer skeleton(IAtomContainer src) {
        int i;
        IChemObjectBuilder builder = src.getBuilder();
        IAtom[] atoms = new IAtom[src.getAtomCount()];
        IBond[] bonds = new IBond[src.getBondCount()];
        for (i = 0; i < atoms.length; ++i) {
            atoms[i] = builder.newInstance(IAtom.class, src.getAtom(i).getSymbol());
        }
        for (i = 0; i < bonds.length; ++i) {
            IBond bond = src.getBond(i);
            int u = src.getAtomNumber(bond.getAtom(0));
            int v = src.getAtomNumber(bond.getAtom(1));
            bonds[i] = builder.newInstance(IBond.class, atoms[u], atoms[v]);
        }
        IAtomContainer dest = builder.newInstance(IAtomContainer.class, 0, 0, 0, 0);
        dest.setAtoms(atoms);
        dest.setBonds(bonds);
        return dest;
    }

    public static double getBondOrderSum(IAtomContainer container, IAtom atom) {
        double count = 0.0;
        for (IBond bond : container.getConnectedBondsList(atom)) {
            IBond.Order order = bond.getOrder();
            if (order == null) continue;
            count += (double)order.numeric().intValue();
        }
        return count;
    }

    public static IAtomContainer setSingleOrDoubleFlags(IAtomContainer ac) {
        RingSearch rs = new RingSearch(ac);
        boolean singleOrDouble = false;
        for (IBond bond : rs.ringFragments().bonds()) {
            if (!bond.getFlag(32)) continue;
            bond.setFlag(4096, true);
            bond.getAtom(0).setFlag(4096, true);
            bond.getAtom(1).setFlag(4096, true);
            singleOrDouble |= true;
        }
        if (singleOrDouble) {
            ac.setFlag(4096, true);
        }
        return ac;
    }
}

