/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smiles;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.graph.GraphUtil;
import org.openscience.cdk.graph.invariant.Canon;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IReaction;
import org.openscience.cdk.smiles.CDKToBeam;
import uk.ac.ebi.beam.Functions;
import uk.ac.ebi.beam.Graph;

public final class SmilesGenerator {
    private final boolean isomeric;
    private final boolean canonical;
    private final boolean aromatic;
    private final boolean classes;
    private final CDKToBeam converter;

    public SmilesGenerator() {
        this(false, false, false, false);
    }

    private SmilesGenerator(boolean isomeric, boolean canonical, boolean aromatic, boolean classes) {
        this.isomeric = isomeric;
        this.canonical = canonical;
        this.aromatic = aromatic;
        this.classes = classes;
        this.converter = new CDKToBeam(isomeric, aromatic, classes);
    }

    public SmilesGenerator aromatic() {
        return new SmilesGenerator(this.isomeric, this.canonical, true, this.classes);
    }

    public SmilesGenerator withAtomClasses() {
        return new SmilesGenerator(this.isomeric, this.canonical, this.aromatic, true);
    }

    public static SmilesGenerator generic() {
        return new SmilesGenerator(false, false, false, false);
    }

    public static SmilesGenerator isomeric() {
        return new SmilesGenerator(true, false, false, false);
    }

    public static SmilesGenerator unique() {
        return new SmilesGenerator(false, true, false, false);
    }

    public static SmilesGenerator absolute() {
        return new SmilesGenerator(true, true, false, false);
    }

    @Deprecated
    public String createSMILES(IAtomContainer molecule) {
        try {
            return this.create(molecule);
        }
        catch (CDKException e) {
            throw new IllegalArgumentException("SMILES could not be generated, please use the new API method 'create()'to catch the checked exception", e);
        }
    }

    @Deprecated
    public String createSMILES(IReaction reaction) {
        try {
            return this.createReactionSMILES(reaction);
        }
        catch (CDKException e) {
            throw new IllegalArgumentException("SMILES could not be generated, please use the new API method 'create()'to catch the checked exception", e);
        }
    }

    public String create(IAtomContainer molecule) throws CDKException {
        return this.create(molecule, new int[molecule.getAtomCount()]);
    }

    public String create(IAtomContainer molecule, int[] order) throws CDKException {
        try {
            if (order.length != molecule.getAtomCount()) {
                throw new IllegalArgumentException("the array for storing output order should bethe same length as the number of atoms");
            }
            Graph g = this.converter.toBeamGraph(molecule);
            if (this.canonical) {
                int[] labels = this.labels(molecule);
                g = g.permute(labels).resonate();
                if (this.isomeric) {
                    g.sort(new Graph.VisitHighOrderFirst());
                    g = Functions.normaliseDirectionalLabels(g);
                    g.sort(new Graph.VisitHighOrderFirst()).sort(new Graph.VisitHydrogenFirst());
                }
                String smiles = g.toSmiles(order);
                int[] canorder = new int[order.length];
                for (int i = 0; i < labels.length; ++i) {
                    canorder[i] = order[labels[i]];
                }
                System.arraycopy(canorder, 0, order, 0, order.length);
                return smiles;
            }
            return g.toSmiles(order);
        }
        catch (IOException e) {
            throw new CDKException(e.getMessage());
        }
    }

    public String createReactionSMILES(IReaction reaction) throws CDKException {
        StringBuffer reactionSMILES = new StringBuffer();
        IAtomContainerSet reactants = reaction.getReactants();
        for (int i = 0; i < reactants.getAtomContainerCount(); ++i) {
            reactionSMILES.append(this.create(reactants.getAtomContainer(i)));
            if (i + 1 >= reactants.getAtomContainerCount()) continue;
            reactionSMILES.append('.');
        }
        reactionSMILES.append('>');
        IAtomContainerSet agents = reaction.getAgents();
        for (int i = 0; i < agents.getAtomContainerCount(); ++i) {
            reactionSMILES.append(this.create(agents.getAtomContainer(i)));
            if (i + 1 >= agents.getAtomContainerCount()) continue;
            reactionSMILES.append('.');
        }
        reactionSMILES.append('>');
        IAtomContainerSet products = reaction.getProducts();
        for (int i = 0; i < products.getAtomContainerCount(); ++i) {
            reactionSMILES.append(this.create(products.getAtomContainer(i)));
            if (i + 1 >= products.getAtomContainerCount()) continue;
            reactionSMILES.append('.');
        }
        return reactionSMILES.toString();
    }

    @Deprecated
    public void setUseAromaticityFlag(boolean useAromaticityFlag) {
    }

    private int[] labels(IAtomContainer molecule) throws CDKException {
        long[] labels = this.isomeric ? this.inchiNumbers(molecule) : Canon.label(molecule, GraphUtil.toAdjList(molecule));
        int[] cpy = new int[labels.length];
        for (int i = 0; i < labels.length; ++i) {
            cpy[i] = (int)labels[i] - 1;
        }
        return cpy;
    }

    private long[] inchiNumbers(IAtomContainer container) throws CDKException {
        String cname = "org.openscience.cdk.graph.invariant.InChINumbersTools";
        String mname = "getUSmilesNumbers";
        try {
            Class<?> c = Class.forName(cname);
            Method method = c.getDeclaredMethod("getUSmilesNumbers", IAtomContainer.class);
            return (long[])method.invoke(c, container);
        }
        catch (ClassNotFoundException e) {
            throw new CDKException("The cdk-inchi module is not loaded, this module is need when gernating absolute SMILES.");
        }
        catch (NoSuchMethodException e) {
            throw new CDKException("The method " + mname + " was not found", e);
        }
        catch (InvocationTargetException e) {
            throw new CDKException("An InChI could not be generated and used to canonise SMILES: " + e.getMessage(), e);
        }
        catch (IllegalAccessException e) {
            throw new CDKException("Could not access method to obtain InChI numbers.");
        }
    }
}

