/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import org.openscience.cdk.config.fragments.EStateFragments;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.qsar.AbstractMolecularDescriptor;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.smiles.smarts.SMARTSQueryTool;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;

public class KierHallSmartsDescriptor
extends AbstractMolecularDescriptor
implements IMolecularDescriptor {
    private static String[] names;
    private static final String[] SMARTS;

    public KierHallSmartsDescriptor() {
        String[] tmp = EStateFragments.getNames();
        names = new String[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            KierHallSmartsDescriptor.names[i] = "khs." + tmp[i];
        }
    }

    @Override
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#kierHallSmarts", this.getClass().getName(), "The Chemistry Development Kit");
    }

    @Override
    public void setParameters(Object[] params) throws CDKException {
        if (params != null) {
            throw new CDKException("Must not supply any parameters");
        }
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String[] getDescriptorNames() {
        return names;
    }

    private DescriptorValue getDummyDescriptorValue(Exception e) {
        IntegerArrayResult result = new IntegerArrayResult();
        for (String smart : SMARTS) {
            result.add(0);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames(), e);
    }

    @Override
    public DescriptorValue calculate(IAtomContainer container) {
        IAtomContainer atomContainer;
        if (container == null || container.getAtomCount() == 0) {
            return this.getDummyDescriptorValue(new CDKException("Container was null or else had no atoms"));
        }
        try {
            atomContainer = container.clone();
            atomContainer = AtomContainerManipulator.removeHydrogens(atomContainer);
        }
        catch (CloneNotSupportedException e) {
            return this.getDummyDescriptorValue(new CDKException("Error during clone"));
        }
        int[] counts = new int[SMARTS.length];
        try {
            SMARTSQueryTool sqt = new SMARTSQueryTool("C", container.getBuilder());
            for (int i = 0; i < SMARTS.length; ++i) {
                sqt.setSmarts(SMARTS[i]);
                boolean status = sqt.matches(atomContainer);
                counts[i] = status ? sqt.getUniqueMatchingAtoms().size() : 0;
            }
        }
        catch (CDKException e) {
            return this.getDummyDescriptorValue(e);
        }
        IntegerArrayResult result = new IntegerArrayResult();
        int[] arr$ = counts;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Integer i = arr$[i$];
            result.add(i);
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), result, this.getDescriptorNames());
    }

    @Override
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerArrayResult(SMARTS.length);
    }

    @Override
    public String[] getParameterNames() {
        return null;
    }

    @Override
    public Object getParameterType(String name) {
        return null;
    }

    static {
        SMARTS = EStateFragments.getSmarts();
    }
}

