/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.io.IChemObjectWriter;
import org.openscience.cdk.io.formats.IChemFormat;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class WriterFactory {
    private static final String IO_FORMATS_LIST = "io-formats.set";
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(WriterFactory.class);
    private static List<IChemFormat> formats = null;
    private static Map<String, Class<IChemObjectWriter>> registeredReaders;

    public WriterFactory() {
        registeredReaders = new HashMap<String, Class<IChemObjectWriter>>();
    }

    public void registerWriter(Class<?> writer) {
        if (writer == null) {
            return;
        }
        if (IChemObjectWriter.class.isAssignableFrom(writer)) {
            registeredReaders.put(writer.getName(), writer);
        }
    }

    public IChemFormat[] findChemFormats(int features) {
        if (formats == null) {
            this.loadFormats();
        }
        Iterator<IChemFormat> iter = formats.iterator();
        ArrayList<IChemFormat> matches = new ArrayList<IChemFormat>();
        while (iter.hasNext()) {
            IChemFormat format = iter.next();
            if ((format.getSupportedDataFeatures() & features) != features) continue;
            matches.add(format);
        }
        return matches.toArray(new IChemFormat[matches.size()]);
    }

    public int formatCount() {
        if (formats == null) {
            this.loadFormats();
        }
        return formats.size();
    }

    private void loadFormats() {
        if (formats == null) {
            formats = new ArrayList<IChemFormat>();
            try {
                logger.debug("Starting loading Formats...");
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream(IO_FORMATS_LIST)));
                int formatCount = 0;
                while (reader.ready()) {
                    String formatName = reader.readLine();
                    ++formatCount;
                    try {
                        Class<?> formatClass = this.getClass().getClassLoader().loadClass(formatName);
                        Method getinstanceMethod = formatClass.getMethod("getInstance", new Class[0]);
                        IResourceFormat format = (IResourceFormat)getinstanceMethod.invoke(null, new Object[0]);
                        if (!(format instanceof IChemFormat)) continue;
                        formats.add((IChemFormat)format);
                        logger.info("Loaded IChemFormat: " + format.getClass().getName());
                    }
                    catch (ClassNotFoundException exception) {
                        logger.error("Could not find this IResourceFormat: ", formatName);
                        logger.debug(exception);
                    }
                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                        logger.error("Could not load this IResourceFormat: ", formatName);
                        logger.debug(exception);
                    }
                }
                logger.info("Number of loaded formats used in detection: ", formatCount);
            }
            catch (Exception exception) {
                logger.error("Could not load this io format list: ", IO_FORMATS_LIST);
                logger.debug(exception);
            }
        }
    }

    public IChemObjectWriter createWriter(IChemFormat format) {
        if (format != null) {
            String writerClassName = format.getWriterClassName();
            if (writerClassName != null) {
                try {
                    Class<IChemObjectWriter> writer;
                    if (registeredReaders.containsKey(writerClassName) && (writer = registeredReaders.get(writerClassName)) != null) {
                        return writer.newInstance();
                    }
                    return (IChemObjectWriter)this.getClass().getClassLoader().loadClass(writerClassName).newInstance();
                }
                catch (ClassNotFoundException exception) {
                    logger.error("Could not find this ChemObjectWriter: ", writerClassName);
                    logger.debug(exception);
                }
                catch (IllegalAccessException | InstantiationException exception) {
                    logger.error("Could not create this ChemObjectWriter: ", writerClassName);
                    logger.debug(exception);
                }
            } else {
                logger.warn("ChemFormat is recognized, but no writer is available.");
            }
        } else {
            logger.warn("ChemFormat is not recognized.");
        }
        return null;
    }
}

