/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jnati.deploy;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class CustomClassLoader
extends ClassLoader {
    public CustomClassLoader() {
        super(CustomClassLoader.class.getClassLoader());
    }

    public CustomClassLoader(ClassLoader parent) {
        super(parent);
    }

    public Class findClass(String name) {
        String file = name.replace('.', File.separatorChar) + ".class";
        try {
            byte[] b = this.loadClassData(file);
            Class<?> c = this.defineClass(name, b, 0, b.length);
            this.resolveClass(c);
            return c;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadClassData(String name) throws IOException {
        InputStream in = this.getResourceAsStream(name);
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            byte[] b = new byte[4096];
            int n = in.read(b);
            while (n != -1) {
                buffer.write(b, 0, n);
                n = in.read(b);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }
}

